/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.SCMSecurityProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.scm.update.client.UpdateServiceConfig;
import org.apache.hadoop.hdds.scm.update.server.SCMCRLStore;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateServiceGrpcServer;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KerberosInfo(serverPrincipal="hdds.scm.kerberos.principal")
@InterfaceAudience.Private
public class SCMSecurityProtocolServer
implements SCMSecurityProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCMSecurityProtocolServer.class);
    private final CertificateServer rootCertificateServer;
    private final CertificateServer scmCertificateServer;
    private final X509Certificate rootCACertificate;
    private final RPC.Server rpcServer;
    private final SCMUpdateServiceGrpcServer grpcUpdateServer;
    private final InetSocketAddress rpcAddress;
    private final ProtocolMessageMetrics metrics;
    private final StorageContainerManager storageContainerManager;

    SCMSecurityProtocolServer(OzoneConfiguration conf, CertificateServer rootCertificateServer, CertificateServer scmCertificateServer, X509Certificate rootCACert, StorageContainerManager scm) throws IOException {
        this.storageContainerManager = scm;
        this.rootCertificateServer = rootCertificateServer;
        this.scmCertificateServer = scmCertificateServer;
        this.rootCACertificate = rootCACert;
        int handlerCount = conf.getInt("ozone.scm.security.handler.count.key", 2);
        this.rpcAddress = HddsServerUtil.getScmSecurityInetAddress((ConfigurationSource)conf);
        RPC.setProtocolEngine((Configuration)conf, SCMSecurityProtocolPB.class, ProtobufRpcEngine.class);
        this.metrics = new ProtocolMessageMetrics("ScmSecurityProtocol", "SCM Security protocol metrics", (Object[])SCMSecurityProtocolProtos.Type.values());
        BlockingService secureProtoPbService = SCMSecurityProtocolProtos.SCMSecurityProtocolService.newReflectiveBlockingService((SCMSecurityProtocolProtos.SCMSecurityProtocolService.BlockingInterface)new SCMSecurityProtocolServerSideTranslatorPB(this, scm, this.metrics));
        this.rpcServer = StorageContainerManager.startRpcServer(conf, this.rpcAddress, SCMSecurityProtocolPB.class, secureProtoPbService, handlerCount);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.rpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
        this.grpcUpdateServer = new SCMUpdateServiceGrpcServer((UpdateServiceConfig)conf.getObject(UpdateServiceConfig.class), new SCMCRLStore(scmCertificateServer));
    }

    public String getDataNodeCertificate(HddsProtos.DatanodeDetailsProto dnDetails, String certSignReq) throws IOException {
        LOGGER.info("Processing CSR for dn {}, UUID: {}", (Object)dnDetails.getHostName(), (Object)dnDetails.getUuid());
        Objects.requireNonNull(dnDetails);
        return this.getEncodedCertToString(certSignReq, HddsProtos.NodeType.DATANODE);
    }

    public String getOMCertificate(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        LOGGER.info("Processing CSR for om {}, UUID: {}", (Object)omDetails.getHostName(), (Object)omDetails.getUuid());
        Objects.requireNonNull(omDetails);
        return this.getEncodedCertToString(certSignReq, HddsProtos.NodeType.OM);
    }

    public String getSCMCertificate(HddsProtos.ScmNodeDetailsProto scmNodeDetails, String certSignReq) throws IOException {
        Objects.requireNonNull(scmNodeDetails);
        String primaryScmId = this.storageContainerManager.getScmStorageConfig().getPrimaryScmNodeId();
        if (primaryScmId != null && primaryScmId.equals(this.storageContainerManager.getScmId())) {
            LOGGER.info("Processing CSR for scm {}, nodeId: {}", (Object)scmNodeDetails.getHostName(), (Object)scmNodeDetails.getScmNodeId());
            if (!this.storageContainerManager.getClusterId().equals(scmNodeDetails.getClusterId())) {
                throw new IOException("SCM ClusterId mismatch. Peer SCM ClusterId " + scmNodeDetails.getClusterId() + ", primary SCM ClusterId " + this.storageContainerManager.getClusterId());
            }
            return this.getEncodedCertToString(certSignReq, HddsProtos.NodeType.SCM);
        }
        throw new SCMSecurityException("Get SCM Certificate can be run only primary SCM", SCMSecurityException.ErrorCode.NOT_A_PRIMARY_SCM);
    }

    private String getEncodedCertToString(String certSignReq, HddsProtos.NodeType nodeType) throws IOException {
        Future future = nodeType == HddsProtos.NodeType.SCM ? this.rootCertificateServer.requestCertificate(certSignReq, CertificateApprover.ApprovalType.KERBEROS_TRUSTED, nodeType) : this.scmCertificateServer.requestCertificate(certSignReq, CertificateApprover.ApprovalType.KERBEROS_TRUSTED, nodeType);
        try {
            return CertificateCodec.getPEMEncodedString((X509CertificateHolder)((X509CertificateHolder)future.get()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.generateException(e, nodeType);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof SCMSecurityException) {
                    throw (SCMSecurityException)e.getCause();
                }
                throw this.generateException(e, nodeType);
            }
            throw this.generateException(e, nodeType);
        }
    }

    private SCMSecurityException generateException(Exception ex, HddsProtos.NodeType role) {
        SCMSecurityException.ErrorCode errorCode = role == HddsProtos.NodeType.SCM ? SCMSecurityException.ErrorCode.GET_SCM_CERTIFICATE_FAILED : (role == HddsProtos.NodeType.OM ? SCMSecurityException.ErrorCode.GET_OM_CERTIFICATE_FAILED : SCMSecurityException.ErrorCode.GET_DN_CERTIFICATE_FAILED);
        return new SCMSecurityException("generate " + role.toString() + " Certificate operation failed", (Throwable)ex, errorCode);
    }

    public String getCertificate(String certSerialId) throws IOException {
        LOGGER.debug("Getting certificate with certificate serial id {}", (Object)certSerialId);
        try {
            X509Certificate certificate = this.scmCertificateServer.getCertificate(certSerialId);
            if (certificate != null) {
                return CertificateCodec.getPEMEncodedString((X509Certificate)certificate);
            }
        }
        catch (CertificateException e) {
            throw new SCMSecurityException("getCertificate operation failed. ", (Throwable)e, SCMSecurityException.ErrorCode.GET_CERTIFICATE_FAILED);
        }
        LOGGER.info("Certificate with serial id {} not found.", (Object)certSerialId);
        throw new SCMSecurityException("Certificate not found", SCMSecurityException.ErrorCode.CERTIFICATE_NOT_FOUND);
    }

    public String getCACertificate() throws IOException {
        LOGGER.debug("Getting CA certificate.");
        try {
            return CertificateCodec.getPEMEncodedString((X509CertificateHolder)this.scmCertificateServer.getCACertificate());
        }
        catch (CertificateException e) {
            throw new SCMSecurityException("getRootCertificate operation failed. ", (Throwable)e, SCMSecurityException.ErrorCode.GET_CA_CERT_FAILED);
        }
    }

    public List<String> listCertificate(HddsProtos.NodeType role, long startSerialId, int count, boolean isRevoked) throws IOException {
        List certificates = this.scmCertificateServer.listCertificate(role, startSerialId, count, isRevoked);
        ArrayList<String> results = new ArrayList<String>(certificates.size());
        for (X509Certificate cert : certificates) {
            try {
                String certStr = CertificateCodec.getPEMEncodedString((X509Certificate)cert);
                results.add(certStr);
            }
            catch (SCMSecurityException e) {
                throw new SCMSecurityException("listCertificate operation failed.", (Throwable)e, e.getErrorCode());
            }
        }
        return results;
    }

    public List<String> listCACertificate() throws IOException {
        List<String> caCerts = this.listCertificate(HddsProtos.NodeType.SCM, 0L, 10, false);
        return caCerts;
    }

    public String getRootCACertificate() throws IOException {
        LOGGER.debug("Getting Root CA certificate.");
        if (this.storageContainerManager.getScmStorageConfig().checkPrimarySCMIdInitialized()) {
            return CertificateCodec.getPEMEncodedString((X509Certificate)this.rootCACertificate);
        }
        return null;
    }

    public List<CRLInfo> getCrls(List<Long> crlIds) throws IOException {
        return this.scmCertificateServer.getCrls(crlIds);
    }

    public long getLatestCrlId() {
        return this.scmCertificateServer.getLatestCrlId();
    }

    public long revokeCertificates(List<String> certIds, int reason, long revocationTime) throws IOException {
        this.storageContainerManager.checkAdminAccess(this.getRpcRemoteUser());
        Future revoked = this.scmCertificateServer.revokeCertificates(certIds.stream().map(id -> new BigInteger((String)id)).collect(Collectors.toList()), CRLReason.lookup((int)reason), new Date(revocationTime));
        try {
            Long crlId = (Long)((Optional)revoked.get()).get();
            this.getGrpcUpdateServer().notifyCrlUpdate();
            return crlId;
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new SCMException("Fail to revoke certs", SCMException.ResultCodes.FAILED_TO_REVOKE_CERTIFICATES);
        }
    }

    public SCMUpdateServiceGrpcServer getGrpcUpdateServer() {
        return this.grpcUpdateServer;
    }

    @VisibleForTesting
    public UserGroupInformation getRpcRemoteUser() {
        return Server.getRemoteUser();
    }

    public RPC.Server getRpcServer() {
        return this.rpcServer;
    }

    public InetSocketAddress getRpcAddress() {
        return this.rpcAddress;
    }

    public void start() throws IOException {
        String startupMsg = StorageContainerManager.buildRpcServerStartMessage("Starting RPC server for SCMSecurityProtocolServer.", this.getRpcAddress());
        LOGGER.info(startupMsg);
        this.metrics.register();
        this.getRpcServer().start();
        this.getGrpcUpdateServer().start();
    }

    public void stop() {
        try {
            LOGGER.info("Stopping the SCMSecurityProtocolServer.");
            this.metrics.unregister();
            this.getRpcServer().stop();
            this.getGrpcUpdateServer().stop();
        }
        catch (Exception ex) {
            LOGGER.error("SCMSecurityProtocolServer stop failed.", (Throwable)ex);
        }
    }

    public void join() throws InterruptedException {
        LOGGER.trace("Join RPC server for SCMSecurityProtocolServer.");
        this.getRpcServer().join();
        LOGGER.trace("Join gRPC server for SCMSecurityProtocolServer.");
        this.getGrpcUpdateServer().join();
    }

    public CertificateServer getRootCertificateServer() {
        return this.rootCertificateServer;
    }

    public CertificateServer getScmCertificateServer() {
        return this.scmCertificateServer;
    }
}

