/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.SCMAction;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.thirdparty.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMClientProtocolServer
implements StorageContainerLocationProtocol,
Auditor {
    private static final Logger LOG = LoggerFactory.getLogger(SCMClientProtocolServer.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.SCMLOGGER);
    private final RPC.Server clientRpcServer;
    private final InetSocketAddress clientRpcAddress;
    private final StorageContainerManager scm;
    private final ProtocolMessageMetrics<ProtocolMessageEnum> protocolMetrics;

    public SCMClientProtocolServer(OzoneConfiguration conf, StorageContainerManager scm) throws IOException {
        this.scm = scm;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 100);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        this.protocolMetrics = ProtocolMessageMetrics.create((String)"ScmContainerLocationProtocol", (String)"SCM ContainerLocation protocol metrics", (Object[])StorageContainerLocationProtocolProtos.Type.values());
        BlockingService storageProtoPbService = StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.newReflectiveBlockingService((StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.BlockingInterface)new StorageContainerLocationProtocolServerSideTranslatorPB(this, scm, this.protocolMetrics));
        InetSocketAddress scmAddress = scm.getScmNodeDetails().getClientProtocolServerAddress();
        this.clientRpcServer = StorageContainerManager.startRpcServer(conf, scmAddress, StorageContainerLocationProtocolPB.class, storageProtoPbService, handlerCount);
        this.clientRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)scm.getScmNodeDetails().getClientProtocolServerAddressKey(), (InetSocketAddress)scmAddress, (RPC.Server)this.clientRpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.clientRpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
        HddsServerUtil.addSuppressedLoggingExceptions((RPC.Server)this.clientRpcServer);
    }

    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    public InetSocketAddress getClientRpcAddress() {
        return this.clientRpcAddress;
    }

    public void start() {
        this.protocolMetrics.register();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Client ", this.getClientRpcAddress()));
        this.getClientRpcServer().start();
    }

    public void stop() {
        this.protocolMetrics.unregister();
        try {
            LOG.info("Stopping the RPC server for Client Protocol");
            this.getClientRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Client Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Client Protocol");
        this.getClientRpcServer().join();
    }

    public UserGroupInformation getRemoteUser() {
        return Server.getRemoteUser();
    }

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        if (this.scm.getScmContext().isInSafeMode()) {
            throw new SCMException("SafeModePrecheck failed for allocateContainer", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        this.getScm().checkAdminAccess(this.getRemoteUser());
        ContainerInfo container = this.scm.getContainerManager().allocateContainer(ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)replicationType, (HddsProtos.ReplicationFactor)factor), owner);
        Pipeline pipeline = this.scm.getPipelineManager().getPipeline(container.getPipelineID());
        return new ContainerWithPipeline(container, pipeline);
    }

    public ContainerInfo getContainer(long containerID) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        this.getScm().checkAdminAccess(this.getRemoteUser());
        try {
            ContainerInfo containerInfo = this.scm.getContainerManager().getContainer(ContainerID.valueOf((long)containerID));
            return containerInfo;
        }
        catch (IOException ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_CONTAINER, auditMap));
            }
        }
    }

    private ContainerWithPipeline getContainerWithPipelineCommon(long containerID) throws IOException {
        Pipeline pipeline;
        ContainerID cid = ContainerID.valueOf((long)containerID);
        ContainerInfo container = this.scm.getContainerManager().getContainer(cid);
        if (this.scm.getScmContext().isInSafeMode() && container.isOpen() && !this.hasRequiredReplicas(container)) {
            throw new SCMException("Open container " + containerID + " doesn't have enough replicas to service this operation in Safe mode.", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        try {
            pipeline = container.isOpen() ? this.scm.getPipelineManager().getPipeline(container.getPipelineID()) : null;
        }
        catch (PipelineNotFoundException ex) {
            pipeline = null;
        }
        if (pipeline == null) {
            pipeline = this.scm.getPipelineManager().createPipeline((ReplicationConfig)new StandaloneReplicationConfig(ReplicationConfig.getLegacyFactor((ReplicationConfig)container.getReplicationConfig())), this.scm.getContainerManager().getContainerReplicas(cid).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList()));
        }
        return new ContainerWithPipeline(container, pipeline);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        this.getScm().checkAdminAccess(null);
        try {
            ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_CONTAINER_WITH_PIPELINE, Collections.singletonMap("containerID", ContainerID.valueOf((long)containerID).toString())));
            return cp;
        }
        catch (IOException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_CONTAINER_WITH_PIPELINE, Collections.singletonMap("containerID", ContainerID.valueOf((long)containerID).toString()), ex));
            throw ex;
        }
    }

    public List<ContainerWithPipeline> getContainerWithPipelineBatch(List<Long> containerIDs) throws IOException {
        this.getScm().checkAdminAccess(null);
        ArrayList<ContainerWithPipeline> cpList = new ArrayList<ContainerWithPipeline>();
        StringBuilder strContainerIDs = new StringBuilder();
        for (Long containerID : containerIDs) {
            try {
                ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
                cpList.add(cp);
                strContainerIDs.append(ContainerID.valueOf((long)containerID).toString());
                strContainerIDs.append(",");
            }
            catch (IOException ex) {
                AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, Collections.singletonMap("containerID", ContainerID.valueOf((long)containerID).toString()), ex));
                throw ex;
            }
        }
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, Collections.singletonMap("containerIDs", strContainerIDs.toString())));
        return cpList;
    }

    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        ArrayList<ContainerWithPipeline> cpList = new ArrayList<ContainerWithPipeline>();
        for (Long containerID : containerIDs) {
            try {
                ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
                cpList.add(cp);
            }
            catch (IOException iOException) {}
        }
        return cpList;
    }

    private boolean hasRequiredReplicas(ContainerInfo contInfo) {
        try {
            return this.getScm().getContainerManager().getContainerReplicas(contInfo.containerID()).size() >= contInfo.getReplicationConfig().getRequiredNodes();
        }
        catch (ContainerNotFoundException ex) {
            return false;
        }
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.listContainer(startContainerID, count, null);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("startContainerID", String.valueOf(startContainerID));
        auditMap.put("count", String.valueOf(count));
        if (state != null) {
            auditMap.put("state", state.name());
        }
        try {
            ContainerID containerId = ContainerID.valueOf((long)startContainerID);
            if (null == state) {
                List<ContainerInfo> list = this.scm.getContainerManager().getContainers(containerId, count);
                return list;
            }
            List<ContainerInfo> list = this.scm.getContainerManager().getContainers(state).stream().filter(info -> info.containerID().getId() >= startContainerID).sorted().limit(count).collect(Collectors.toList());
            return list;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.LIST_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.LIST_CONTAINER, auditMap));
            }
        }
    }

    public void deleteContainer(long containerID) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        UserGroupInformation remoteUser = this.getRemoteUser();
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            this.getScm().checkAdminAccess(remoteUser);
            this.scm.getContainerManager().deleteContainer(ContainerID.valueOf((long)containerID));
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.DELETE_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.DELETE_CONTAINER, auditMap));
            }
        }
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState state, HddsProtos.QueryScope queryScope, String poolName, int clientVersion) throws IOException {
        if (queryScope == HddsProtos.QueryScope.POOL) {
            throw new IllegalArgumentException("Not Supported yet");
        }
        ArrayList<HddsProtos.Node> result = new ArrayList<HddsProtos.Node>();
        for (DatanodeDetails node : this.queryNode(opState, state)) {
            try {
                NodeStatus ns = this.scm.getScmNodeManager().getNodeStatus(node);
                result.add(HddsProtos.Node.newBuilder().setNodeID(node.toProto(clientVersion)).addNodeStates(ns.getHealth()).addNodeOperationalStates(ns.getOperationalState()).build());
            }
            catch (NodeNotFoundException e) {
                throw new IOException("An unexpected error occurred querying the NodeStatus", e);
            }
        }
        return result;
    }

    public List<DatanodeAdminError> decommissionNodes(List<String> nodes) throws IOException {
        try {
            this.getScm().checkAdminAccess(this.getRemoteUser());
            return this.scm.getScmDecommissionManager().decommissionNodes(nodes);
        }
        catch (Exception ex) {
            LOG.error("Failed to decommission nodes", (Throwable)ex);
            throw ex;
        }
    }

    public List<DatanodeAdminError> recommissionNodes(List<String> nodes) throws IOException {
        try {
            this.getScm().checkAdminAccess(this.getRemoteUser());
            return this.scm.getScmDecommissionManager().recommissionNodes(nodes);
        }
        catch (Exception ex) {
            LOG.error("Failed to recommission nodes", (Throwable)ex);
            throw ex;
        }
    }

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> nodes, int endInHours) throws IOException {
        try {
            this.getScm().checkAdminAccess(this.getRemoteUser());
            return this.scm.getScmDecommissionManager().startMaintenanceNodes(nodes, endInHours);
        }
        catch (Exception ex) {
            LOG.error("Failed to place nodes into maintenance mode", (Throwable)ex);
            throw ex;
        }
    }

    public void closeContainer(long containerID) throws IOException {
        UserGroupInformation remoteUser = this.getRemoteUser();
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            this.scm.checkAdminAccess(remoteUser);
            ContainerID cid = ContainerID.valueOf((long)containerID);
            HddsProtos.LifeCycleState state = this.scm.getContainerManager().getContainer(cid).getState();
            if (!state.equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                throw new SCMException("Cannot close a " + state + " container.", SCMException.ResultCodes.UNEXPECTED_CONTAINER_STATE);
            }
            this.scm.getEventQueue().fireEvent(SCMEvents.CLOSE_CONTAINER, (Object)ContainerID.valueOf((long)containerID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.CLOSE_CONTAINER, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.CLOSE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        Pipeline result = this.scm.getPipelineManager().createPipeline(ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor));
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.CREATE_PIPELINE, null));
        return result;
    }

    public List<Pipeline> listPipelines() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.LIST_PIPELINE, null));
        return this.scm.getPipelineManager().getPipelines();
    }

    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.scm.getPipelineManager().getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
    }

    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.ACTIVATE_PIPELINE, null));
        this.scm.getPipelineManager().activatePipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
    }

    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.getScm().checkAdminAccess(this.getRemoteUser());
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.DEACTIVATE_PIPELINE, null));
        this.scm.getPipelineManager().deactivatePipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.getScm().checkAdminAccess(this.getRemoteUser());
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        PipelineManager pipelineManager = this.scm.getPipelineManager();
        Pipeline pipeline = pipelineManager.getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
        pipelineManager.closePipeline(pipeline, true);
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.CLOSE_PIPELINE, null));
    }

    public ScmInfo getScmInfo() throws IOException {
        boolean auditSuccess = true;
        try {
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorageConfig().getClusterID()).setScmId(this.scm.getScmStorageConfig().getScmId());
            if (this.scm.getScmHAManager().getRatisServer() != null) {
                builder.setRatisPeerRoles(this.scm.getScmHAManager().getRatisServer().getRatisRoles());
            } else {
                String adddress = this.scm.getSCMHANodeDetails().getLocalNodeDetails().getRatisHostPortStr();
                builder.setRatisPeerRoles(Arrays.asList(adddress));
            }
            ScmInfo scmInfo = builder.build();
            return scmInfo;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_SCM_INFO, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_SCM_INFO, null));
            }
        }
    }

    public boolean inSafeMode() throws IOException {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.IN_SAFE_MODE, null));
        return this.scm.isInSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        return this.scm.getRuleStatus();
    }

    public boolean forceExitSafeMode() throws IOException {
        this.getScm().checkAdminAccess(this.getRemoteUser());
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.FORCE_EXIT_SAFE_MODE, null));
        return this.scm.exitSafeMode();
    }

    public void startReplicationManager() throws IOException {
        this.getScm().checkAdminAccess(this.getRemoteUser());
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.START_REPLICATION_MANAGER, null));
        this.scm.getReplicationManager().start();
    }

    public void stopReplicationManager() throws IOException {
        this.getScm().checkAdminAccess(this.getRemoteUser());
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.STOP_REPLICATION_MANAGER, null));
        this.scm.getReplicationManager().stop();
    }

    public boolean getReplicationManagerStatus() {
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_REPLICATION_MANAGER_STATUS, null));
        return this.scm.getReplicationManager().isRunning();
    }

    public UpgradeFinalizer.StatusAndMessages finalizeScmUpgrade(String upgradeClientID) throws IOException {
        try {
            this.getScm().checkAdminAccess(this.getRemoteUser());
        }
        catch (IOException e) {
            LOG.error("Authorization failed for finalize scm upgrade", (Throwable)e);
            throw e;
        }
        return this.scm.finalizeUpgrade(upgradeClientID);
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean force, boolean readonly) throws IOException {
        if (!readonly) {
            try {
                this.getScm().checkAdminAccess(this.getRemoteUser());
            }
            catch (IOException e) {
                LOG.error("Authorization failed for query scm upgrade finalization progress", (Throwable)e);
                throw e;
            }
        }
        return this.scm.queryUpgradeFinalizationProgress(upgradeClientID, force, readonly);
    }

    public boolean startContainerBalancer(Optional<Double> threshold, Optional<Integer> idleiterations, Optional<Double> maxDatanodesRatioToInvolvePerIteration, Optional<Long> maxSizeToMovePerIterationInGB, Optional<Long> maxSizeEnteringTarget, Optional<Long> maxSizeLeavingSource) throws IOException {
        boolean isStartedSuccessfully;
        this.getScm().checkAdminAccess(this.getRemoteUser());
        ContainerBalancerConfiguration cbc = new ContainerBalancerConfiguration(this.scm.getConfiguration());
        if (threshold.isPresent()) {
            double tsd = threshold.get();
            Preconditions.checkState((tsd >= 0.0 && tsd < 1.0 ? 1 : 0) != 0, (Object)"threshold should to be specified in range [0.0, 1.0).");
            cbc.setThreshold(tsd);
        }
        if (maxSizeToMovePerIterationInGB.isPresent()) {
            long mstm = maxSizeToMovePerIterationInGB.get();
            Preconditions.checkState((mstm > 0L ? 1 : 0) != 0, (Object)"maxSizeToMovePerIterationInGB must be positive.");
            cbc.setMaxSizeToMovePerIteration(mstm * 0x40000000L);
        }
        if (maxDatanodesRatioToInvolvePerIteration.isPresent()) {
            double mdti = maxDatanodesRatioToInvolvePerIteration.get();
            Preconditions.checkState((mdti >= 0.0 ? 1 : 0) != 0, (Object)"maxDatanodesRatioToInvolvePerIteration must be greater than equal to zero.");
            Preconditions.checkState((mdti <= 1.0 ? 1 : 0) != 0, (Object)"maxDatanodesRatioToInvolvePerIteration must be lesser than or equal to one.");
            cbc.setMaxDatanodesRatioToInvolvePerIteration(mdti);
        }
        if (idleiterations.isPresent()) {
            int idi = idleiterations.get();
            Preconditions.checkState((idi > 0 || idi == -1 ? 1 : 0) != 0, (Object)"idleiterations must be positive or -1(infinitly run container balancer).");
            cbc.setIdleIteration(idi);
        }
        if (maxSizeEnteringTarget.isPresent()) {
            long mset = maxSizeEnteringTarget.get();
            Preconditions.checkState((mset > 0L ? 1 : 0) != 0, (Object)"maxSizeEnteringTarget must be greater than zero.");
            cbc.setMaxSizeEnteringTarget(mset * 0x40000000L);
        }
        if (maxSizeLeavingSource.isPresent()) {
            long msls = maxSizeLeavingSource.get();
            Preconditions.checkState((msls > 0L ? 1 : 0) != 0, (Object)"maxSizeLeavingSource must be greater than zero.");
            cbc.setMaxSizeLeavingSource(msls * 0x40000000L);
        }
        if (isStartedSuccessfully = this.scm.getContainerBalancer().start(cbc)) {
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.START_CONTAINER_BALANCER, null));
        } else {
            AUDIT.logWriteFailure(this.buildAuditMessageForSuccess((AuditAction)SCMAction.START_CONTAINER_BALANCER, null));
        }
        return isStartedSuccessfully;
    }

    public void stopContainerBalancer() throws IOException {
        this.getScm().checkAdminAccess(this.getRemoteUser());
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.STOP_CONTAINER_BALANCER, null));
        this.scm.getContainerBalancer().stop();
    }

    public boolean getContainerBalancerStatus() {
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_CONTAINER_BALANCER_STATUS, null));
        return this.scm.getContainerBalancer().isBalancerRunning();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String ipaddress, String uuid) throws IOException {
        try {
            this.getScm().checkAdminAccess(this.getRemoteUser());
        }
        catch (IOException e) {
            LOG.error("Authorization failed", (Throwable)e);
            throw e;
        }
        List<Object> nodes = new ArrayList<DatanodeDetails>();
        if (!Strings.isNullOrEmpty((String)uuid)) {
            nodes.add(this.scm.getScmNodeManager().getNodeByUuid(uuid));
        } else if (!Strings.isNullOrEmpty((String)ipaddress)) {
            nodes = this.scm.getScmNodeManager().getNodesByAddress(ipaddress);
        } else {
            throw new IOException("Could not get datanode with the specified parameters.");
        }
        ArrayList<HddsProtos.DatanodeUsageInfoProto> infoList = new ArrayList<HddsProtos.DatanodeUsageInfoProto>();
        for (DatanodeDetails datanodeDetails : nodes) {
            infoList.add(this.getUsageInfoFromDatanodeDetails(datanodeDetails));
        }
        return infoList;
    }

    private HddsProtos.DatanodeUsageInfoProto getUsageInfoFromDatanodeDetails(DatanodeDetails node) {
        SCMNodeStat stat = this.scm.getScmNodeManager().getNodeStat(node).get();
        long capacity = stat.getCapacity().get();
        long used = stat.getScmUsed().get();
        long remaining = stat.getRemaining().get();
        return HddsProtos.DatanodeUsageInfoProto.newBuilder().setCapacity(capacity).setUsed(used).setRemaining(remaining).setNode(node.toProto(node.getCurrentVersion())).build();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count) throws IOException, IllegalArgumentException {
        try {
            this.getScm().checkAdminAccess(this.getRemoteUser());
        }
        catch (IOException e) {
            LOG.error("Authorization failed", (Throwable)e);
            throw e;
        }
        if (count < 1) {
            throw new IllegalArgumentException("The specified parameter count must be an integer greater than zero.");
        }
        List<DatanodeUsageInfo> datanodeUsageInfoList = this.scm.getScmNodeManager().getMostOrLeastUsedDatanodes(mostUsed);
        if (count > datanodeUsageInfoList.size()) {
            count = datanodeUsageInfoList.size();
        }
        return datanodeUsageInfoList.stream().map(DatanodeUsageInfo::toProto).limit(count).collect(Collectors.toList());
    }

    public Token<?> getContainerToken(ContainerID containerID) throws IOException {
        UserGroupInformation remoteUser = this.getRemoteUser();
        this.getScm().checkAdminAccess(remoteUser);
        return this.scm.getContainerTokenGenerator().generateToken(remoteUser.getUserName(), containerID);
    }

    public List<DatanodeDetails> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState state) {
        return new ArrayList<DatanodeDetails>(this.queryNodeState(opState, state));
    }

    @VisibleForTesting
    public StorageContainerManager getScm() {
        return this.scm;
    }

    public boolean getSafeModeStatus() {
        return this.scm.getScmContext().isInSafeMode();
    }

    private Set<DatanodeDetails> queryNodeState(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState) {
        TreeSet<DatanodeDetails> returnSet = new TreeSet<DatanodeDetails>();
        List<DatanodeDetails> tmp = this.scm.getScmNodeManager().getNodes(opState, nodeState);
        if (tmp != null && tmp.size() > 0) {
            returnSet.addAll(tmp);
        }
        return returnSet;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    public void close() throws IOException {
        this.stop();
    }
}

