/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeleteBlockResult;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.SCMAction;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockProtocolServer
implements ScmBlockLocationProtocol,
Auditor {
    private static final Logger LOG = LoggerFactory.getLogger(SCMBlockProtocolServer.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.SCMLOGGER);
    private final StorageContainerManager scm;
    private final OzoneConfiguration conf;
    private final RPC.Server blockRpcServer;
    private final InetSocketAddress blockRpcAddress;
    private final ProtocolMessageMetrics<ProtocolMessageEnum> protocolMessageMetrics;

    public SCMBlockProtocolServer(OzoneConfiguration conf, StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.conf = conf;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 100);
        RPC.setProtocolEngine((Configuration)conf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        this.protocolMessageMetrics = ProtocolMessageMetrics.create((String)"ScmBlockLocationProtocol", (String)"SCM Block location protocol counters", (Object[])ScmBlockLocationProtocolProtos.Type.values());
        BlockingService blockProtoPbService = ScmBlockLocationProtocolProtos.ScmBlockLocationProtocolService.newReflectiveBlockingService((ScmBlockLocationProtocolProtos.ScmBlockLocationProtocolService.BlockingInterface)new ScmBlockLocationProtocolServerSideTranslatorPB(this, scm, this.protocolMessageMetrics));
        InetSocketAddress scmBlockAddress = scm.getScmNodeDetails().getBlockProtocolServerAddress();
        this.blockRpcServer = StorageContainerManager.startRpcServer(conf, scmBlockAddress, ScmBlockLocationProtocolPB.class, blockProtoPbService, handlerCount);
        this.blockRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)scm.getScmNodeDetails().getBlockProtocolServerAddressKey(), (InetSocketAddress)scmBlockAddress, (RPC.Server)this.blockRpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.blockRpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
        HddsServerUtil.addSuppressedLoggingExceptions((RPC.Server)this.blockRpcServer);
    }

    public RPC.Server getBlockRpcServer() {
        return this.blockRpcServer;
    }

    public InetSocketAddress getBlockRpcAddress() {
        return this.blockRpcAddress;
    }

    public void start() {
        this.protocolMessageMetrics.register();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Block Protocol", this.getBlockRpcAddress()));
        this.getBlockRpcServer().start();
    }

    public void stop() {
        try {
            this.protocolMessageMetrics.unregister();
            LOG.info("Stopping the RPC server for Block Protocol");
            this.getBlockRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Block Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Block Protocol");
        this.getBlockRpcServer().join();
    }

    public List<AllocatedBlock> allocateBlock(long size, int num, ReplicationConfig replicationConfig, String owner, ExcludeList excludeList) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("size", String.valueOf(size));
        auditMap.put("num", String.valueOf(num));
        auditMap.put("replication", replicationConfig.toString());
        auditMap.put("owner", owner);
        ArrayList<AllocatedBlock> blocks = new ArrayList<AllocatedBlock>(num);
        boolean auditSuccess = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Allocating {} blocks of size {}, with {}", new Object[]{num, size, excludeList});
        }
        try {
            for (int i = 0; i < num; ++i) {
                AllocatedBlock block = this.scm.getScmBlockManager().allocateBlock(size, replicationConfig, owner, excludeList);
                if (block == null) continue;
                blocks.add(block);
            }
            ArrayList<AllocatedBlock> i = blocks;
            return i;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.ALLOCATE_BLOCK, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.ALLOCATE_BLOCK, auditMap));
            }
        }
    }

    public List<DeleteBlockGroupResult> deleteKeyBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result resultCode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("SCM is informed by OM to delete {} blocks", (Object)keyBlocksInfoList.size());
        }
        ArrayList<DeleteBlockGroupResult> results = new ArrayList<DeleteBlockGroupResult>();
        HashMap auditMap = Maps.newHashMap();
        IOException e = null;
        try {
            this.scm.getScmBlockManager().deleteBlocks(keyBlocksInfoList);
            resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.success;
        }
        catch (IOException ioe) {
            e = ioe;
            LOG.warn("Fail to delete {} keys", (Object)keyBlocksInfoList.size(), (Object)ioe);
            switch (ioe instanceof SCMException ? ((SCMException)((Object)ioe)).getResult() : SCMException.ResultCodes.IO_EXCEPTION) {
                case SAFE_MODE_EXCEPTION: {
                    resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.safeMode;
                    break;
                }
                case FAILED_TO_FIND_BLOCK: {
                    resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.errorNotFound;
                    break;
                }
                default: {
                    resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.unknownFailure;
                }
            }
        }
        for (BlockGroup bg : keyBlocksInfoList) {
            auditMap.put("KeyBlockToDelete", bg.toString());
            ArrayList<DeleteBlockResult> blockResult = new ArrayList<DeleteBlockResult>();
            for (BlockID b : bg.getBlockIDList()) {
                blockResult.add(new DeleteBlockResult(b, resultCode));
            }
            results.add(new DeleteBlockGroupResult(bg.getGroupID(), blockResult));
        }
        if (e == null) {
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.DELETE_KEY_BLOCK, auditMap));
        } else {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.DELETE_KEY_BLOCK, auditMap, e));
        }
        return results;
    }

    public ScmInfo getScmInfo() throws IOException {
        boolean auditSuccess = true;
        try {
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorageConfig().getClusterID()).setScmId(this.scm.getScmStorageConfig().getScmId());
            ScmInfo scmInfo = builder.build();
            return scmInfo;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_SCM_INFO, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_SCM_INFO, null));
            }
        }
    }

    public boolean addSCM(AddSCMRequest request) throws IOException {
        LOG.debug("Adding SCM {} addr {} cluster id {}", new Object[]{request.getScmId(), request.getRatisAddr(), request.getClusterId()});
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("scmId", String.valueOf(request.getScmId()));
        auditMap.put("cluster", String.valueOf(request.getClusterId()));
        auditMap.put("addr", String.valueOf(request.getRatisAddr()));
        boolean auditSuccess = true;
        try {
            boolean bl = this.scm.getScmHAManager().addSCM(request);
            return bl;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.ADD_SCM, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.ADD_SCM, auditMap));
            }
        }
    }

    public List<DatanodeDetails> sortDatanodes(List<String> nodes, String clientMachine) throws IOException {
        boolean auditSuccess = true;
        try {
            NodeManager nodeManager = this.scm.getScmNodeManager();
            Node client = null;
            List<DatanodeDetails> possibleClients = nodeManager.getNodesByAddress(clientMachine);
            if (possibleClients.size() > 0) {
                client = (Node)possibleClients.get(0);
            }
            ArrayList nodeList = new ArrayList();
            nodes.stream().forEach(uuid -> {
                DatanodeDetails node = nodeManager.getNodeByUuid((String)uuid);
                if (node != null) {
                    nodeList.add(node);
                }
            });
            List sortedNodeList = this.scm.getClusterMap().sortByDistanceCost(client, nodeList, nodes.size());
            ArrayList<DatanodeDetails> ret = new ArrayList<DatanodeDetails>();
            sortedNodeList.stream().forEach(node -> ret.add((DatanodeDetails)node));
            ArrayList<DatanodeDetails> arrayList = ret;
            return arrayList;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.SORT_DATANODE, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.SORT_DATANODE, null));
            }
        }
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    public void close() throws IOException {
        this.stop();
    }
}

