/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.ha.RatisUtil;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.OzonePBHelper;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolServerSideTranslatorPB
implements StorageContainerLocationProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerLocationProtocolServerSideTranslatorPB.class);
    private final StorageContainerLocationProtocol impl;
    private final StorageContainerManager scm;
    private OzoneProtocolMessageDispatcher<StorageContainerLocationProtocolProtos.ScmContainerLocationRequest, StorageContainerLocationProtocolProtos.ScmContainerLocationResponse, ProtocolMessageEnum> dispatcher;

    public StorageContainerLocationProtocolServerSideTranslatorPB(StorageContainerLocationProtocol impl, StorageContainerManager scm, ProtocolMessageMetrics<ProtocolMessageEnum> protocolMetrics) throws IOException {
        this.impl = impl;
        this.scm = scm;
        this.dispatcher = new OzoneProtocolMessageDispatcher("ScmContainerLocation", protocolMetrics, LOG);
    }

    public StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(RpcController controller, StorageContainerLocationProtocolProtos.ScmContainerLocationRequest request) throws ServiceException {
        if (!this.scm.checkLeader() && !StorageContainerLocationProtocol.ADMIN_COMMAND_TYPE.contains(request.getCmdType())) {
            RatisUtil.checkRatisException((IOException)((Object)this.scm.getScmHAManager().getRatisServer().triggerNotLeaderException()), this.scm.getClientRpcPort(), this.scm.getScmId());
        }
        return (StorageContainerLocationProtocolProtos.ScmContainerLocationResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
    }

    public StorageContainerLocationProtocolProtos.ScmContainerLocationResponse processRequest(StorageContainerLocationProtocolProtos.ScmContainerLocationRequest request) throws ServiceException {
        try {
            switch (request.getCmdType()) {
                case AllocateContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerResponse(this.allocateContainer(request.getContainerRequest(), request.getVersion())).build();
                }
                case GetContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerResponse(this.getContainer(request.getGetContainerRequest())).build();
                }
                case GetContainerToken: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerTokenResponse(this.getContainerToken(request.getContainerTokenRequest())).build();
                }
                case GetContainerWithPipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerWithPipelineResponse(this.getContainerWithPipeline(request.getGetContainerWithPipelineRequest(), request.getVersion())).build();
                }
                case GetContainerWithPipelineBatch: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerWithPipelineBatchResponse(this.getContainerWithPipelineBatch(request.getGetContainerWithPipelineBatchRequest(), request.getVersion())).build();
                }
                case GetExistContainerWithPipelinesInBatch: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetExistContainerWithPipelinesInBatchResponse(this.getExistContainerWithPipelinesInBatch(request.getGetExistContainerWithPipelinesInBatchRequest(), request.getVersion())).build();
                }
                case ListContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setScmListContainerResponse(this.listContainer(request.getScmListContainerRequest())).build();
                }
                case QueryNode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setNodeQueryResponse(this.queryNode(request.getNodeQueryRequest(), request.getVersion())).build();
                }
                case CloseContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setScmCloseContainerResponse(this.closeContainer(request.getScmCloseContainerRequest())).build();
                }
                case AllocatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setPipelineResponse(this.allocatePipeline(request.getPipelineRequest(), request.getVersion())).build();
                }
                case ListPipelines: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setListPipelineResponse(this.listPipelines(request.getListPipelineRequest(), request.getVersion())).build();
                }
                case ActivatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setActivatePipelineResponse(this.activatePipeline(request.getActivatePipelineRequest())).build();
                }
                case DeactivatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDeactivatePipelineResponse(this.deactivatePipeline(request.getDeactivatePipelineRequest())).build();
                }
                case ClosePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setClosePipelineResponse(this.closePipeline(request.getClosePipelineRequest())).build();
                }
                case GetScmInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetScmInfoResponse(this.getScmInfo(request.getGetScmInfoRequest())).build();
                }
                case InSafeMode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setInSafeModeResponse(this.inSafeMode(request.getInSafeModeRequest())).build();
                }
                case ForceExitSafeMode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setForceExitSafeModeResponse(this.forceExitSafeMode(request.getForceExitSafeModeRequest())).build();
                }
                case StartReplicationManager: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartReplicationManagerResponse(this.startReplicationManager(request.getStartReplicationManagerRequest())).build();
                }
                case StopReplicationManager: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStopReplicationManagerResponse(this.stopReplicationManager(request.getStopReplicationManagerRequest())).build();
                }
                case GetReplicationManagerStatus: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setReplicationManagerStatusResponse(this.getReplicationManagerStatus(request.getSeplicationManagerStatusRequest())).build();
                }
                case StartContainerBalancer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartContainerBalancerResponse(this.startContainerBalancer(request.getStartContainerBalancerRequest())).build();
                }
                case StopContainerBalancer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStopContainerBalancerResponse(this.stopContainerBalancer(request.getStopContainerBalancerRequest())).build();
                }
                case GetContainerBalancerStatus: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerBalancerStatusResponse(this.getContainerBalancerStatus(request.getContainerBalancerStatusRequest())).build();
                }
                case GetPipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetPipelineResponse(this.getPipeline(request.getGetPipelineRequest(), request.getVersion())).build();
                }
                case GetSafeModeRuleStatuses: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetSafeModeRuleStatusesResponse(this.getSafeModeRuleStatues(request.getGetSafeModeRuleStatusesRequest())).build();
                }
                case DecommissionNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDecommissionNodesResponse(this.decommissionNodes(request.getDecommissionNodesRequest())).build();
                }
                case RecommissionNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setRecommissionNodesResponse(this.recommissionNodes(request.getRecommissionNodesRequest())).build();
                }
                case StartMaintenanceNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartMaintenanceNodesResponse(this.startMaintenanceNodes(request.getStartMaintenanceNodesRequest())).build();
                }
                case FinalizeScmUpgrade: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setFinalizeScmUpgradeResponse(this.getFinalizeScmUpgrade(request.getFinalizeScmUpgradeRequest())).build();
                }
                case QueryUpgradeFinalizationProgress: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setQueryUpgradeFinalizationProgressResponse(this.getQueryUpgradeFinalizationProgress(request.getQueryUpgradeFinalizationProgressRequest())).build();
                }
                case DatanodeUsageInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDatanodeUsageInfoResponse(this.getDatanodeUsageInfo(request.getDatanodeUsageInfoRequest())).build();
                }
            }
            throw new IllegalArgumentException("Unknown command type: " + request.getCmdType());
        }
        catch (IOException e) {
            RatisUtil.checkRatisException(e, this.scm.getClientRpcPort(), this.scm.getScmId());
            throw new ServiceException((Throwable)e);
        }
    }

    public StorageContainerLocationProtocolProtos.ContainerResponseProto allocateContainer(StorageContainerLocationProtocolProtos.ContainerRequestProto request, int clientVersion) throws IOException {
        ContainerWithPipeline cp = this.impl.allocateContainer(request.getReplicationType(), request.getReplicationFactor(), request.getOwner());
        return StorageContainerLocationProtocolProtos.ContainerResponseProto.newBuilder().setContainerWithPipeline(cp.getProtobuf(clientVersion)).setErrorCode(StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerResponseProto getContainer(StorageContainerLocationProtocolProtos.GetContainerRequestProto request) throws IOException {
        ContainerInfo container = this.impl.getContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.GetContainerResponseProto.newBuilder().setContainerInfo(container.getProtobuf()).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerTokenResponseProto getContainerToken(StorageContainerLocationProtocolProtos.GetContainerTokenRequestProto request) throws IOException {
        ContainerID containerID = ContainerID.getFromProtobuf((HddsProtos.ContainerID)request.getContainerID());
        HddsProtos.TokenProto token = OzonePBHelper.protoFromToken((Token)this.impl.getContainerToken(containerID));
        return StorageContainerLocationProtocolProtos.GetContainerTokenResponseProto.newBuilder().setToken(token).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto getContainerWithPipeline(StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request, int clientVersion) throws IOException {
        ContainerWithPipeline container = this.impl.getContainerWithPipeline(request.getContainerID());
        return StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto.newBuilder().setContainerWithPipeline(container.getProtobuf(clientVersion)).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto getContainerWithPipelineBatch(StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto request, int clientVersion) throws IOException {
        List containers = this.impl.getContainerWithPipelineBatch(request.getContainerIDsList());
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto.newBuilder();
        for (ContainerWithPipeline container : containers) {
            builder.addContainerWithPipelines(container.getProtobuf(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchResponseProto getExistContainerWithPipelinesInBatch(StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchRequestProto request, int clientVersion) throws IOException {
        List containers = this.impl.getExistContainerWithPipelinesInBatch(request.getContainerIDsList());
        StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchResponseProto.newBuilder();
        for (ContainerWithPipeline container : containers) {
            builder.addContainerWithPipelines(container.getProtobuf(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.SCMListContainerResponseProto listContainer(StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request) throws IOException {
        long startContainerID = 0L;
        int count = -1;
        if (request.hasStartContainerID()) {
            startContainerID = request.getStartContainerID();
        }
        count = request.getCount();
        HddsProtos.LifeCycleState state = null;
        if (request.hasState()) {
            state = request.getState();
        }
        List containerList = this.impl.listContainer(startContainerID, count, state);
        StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.newBuilder();
        for (ContainerInfo container : containerList) {
            builder.addContainers(container.getProtobuf());
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto deleteContainer(StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request) throws IOException {
        this.impl.deleteContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.NodeQueryResponseProto queryNode(StorageContainerLocationProtocolProtos.NodeQueryRequestProto request, int clientVersion) throws IOException {
        HddsProtos.NodeOperationalState opState = null;
        HddsProtos.NodeState nodeState = null;
        if (request.hasState()) {
            nodeState = request.getState();
        }
        if (request.hasOpState()) {
            opState = request.getOpState();
        }
        List datanodes = this.impl.queryNode(opState, nodeState, request.getScope(), request.getPoolName(), clientVersion);
        return StorageContainerLocationProtocolProtos.NodeQueryResponseProto.newBuilder().addAllDatanodes((Iterable)datanodes).build();
    }

    public StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto closeContainer(StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto request) throws IOException {
        this.impl.closeContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.PipelineResponseProto allocatePipeline(StorageContainerLocationProtocolProtos.PipelineRequestProto request, int clientVersion) throws IOException {
        Pipeline pipeline = this.impl.createReplicationPipeline(request.getReplicationType(), request.getReplicationFactor(), HddsProtos.NodePool.getDefaultInstance());
        if (pipeline == null) {
            return StorageContainerLocationProtocolProtos.PipelineResponseProto.newBuilder().setErrorCode(StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.errorPipelineAlreadyExists).build();
        }
        return StorageContainerLocationProtocolProtos.PipelineResponseProto.newBuilder().setErrorCode(StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success).setPipeline(pipeline.getProtobufMessage(clientVersion)).build();
    }

    public StorageContainerLocationProtocolProtos.ListPipelineResponseProto listPipelines(StorageContainerLocationProtocolProtos.ListPipelineRequestProto request, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.ListPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.ListPipelineResponseProto.newBuilder();
        List pipelines = this.impl.listPipelines();
        for (Pipeline pipeline : pipelines) {
            builder.addPipelines(pipeline.getProtobufMessage(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.GetPipelineResponseProto getPipeline(StorageContainerLocationProtocolProtos.GetPipelineRequestProto request, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.GetPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetPipelineResponseProto.newBuilder();
        Pipeline pipeline = this.impl.getPipeline(request.getPipelineID());
        builder.setPipeline(pipeline.getProtobufMessage(clientVersion));
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.ActivatePipelineResponseProto activatePipeline(StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto request) throws IOException {
        this.impl.activatePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.ActivatePipelineResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.DeactivatePipelineResponseProto deactivatePipeline(StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto request) throws IOException {
        this.impl.deactivatePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.DeactivatePipelineResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ClosePipelineResponseProto closePipeline(StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request) throws IOException {
        this.impl.closePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.ClosePipelineResponseProto.newBuilder().build();
    }

    public HddsProtos.GetScmInfoResponseProto getScmInfo(HddsProtos.GetScmInfoRequestProto req) throws IOException {
        ScmInfo scmInfo = this.impl.getScmInfo();
        return HddsProtos.GetScmInfoResponseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).addAllPeerRoles((Iterable)scmInfo.getRatisPeerRoles()).build();
    }

    public StorageContainerLocationProtocolProtos.InSafeModeResponseProto inSafeMode(StorageContainerLocationProtocolProtos.InSafeModeRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.InSafeModeResponseProto.newBuilder().setInSafeMode(this.impl.inSafeMode()).build();
    }

    public StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto getSafeModeRuleStatues(StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto request) throws IOException {
        Map map = this.impl.getSafeModeRuleStatuses();
        ArrayList<StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto> proto = new ArrayList<StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto>();
        for (Map.Entry entry : map.entrySet()) {
            proto.add(StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto.newBuilder().setRuleName((String)entry.getKey()).setValidate(((Boolean)((Pair)entry.getValue()).getLeft()).booleanValue()).setStatusText((String)((Pair)entry.getValue()).getRight()).build());
        }
        return StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto.newBuilder().addAllSafeModeRuleStatusesProto(proto).build();
    }

    public StorageContainerLocationProtocolProtos.FinalizeScmUpgradeResponseProto getFinalizeScmUpgrade(StorageContainerLocationProtocolProtos.FinalizeScmUpgradeRequestProto request) throws IOException {
        UpgradeFinalizer.StatusAndMessages progress = this.impl.finalizeScmUpgrade(request.getUpgradeClientId());
        HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)progress.status().name());
        HddsProtos.UpgradeFinalizationStatus response = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).addAllMessages((Iterable)progress.msgs()).build();
        return StorageContainerLocationProtocolProtos.FinalizeScmUpgradeResponseProto.newBuilder().setStatus(response).build();
    }

    public StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressResponseProto getQueryUpgradeFinalizationProgress(StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressRequestProto request) throws IOException {
        UpgradeFinalizer.StatusAndMessages progress = this.impl.queryUpgradeFinalizationProgress(request.getUpgradeClientId(), request.getTakeover(), request.getReadonly());
        HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)progress.status().name());
        HddsProtos.UpgradeFinalizationStatus response = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).addAllMessages((Iterable)progress.msgs()).build();
        return StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressResponseProto.newBuilder().setStatus(response).build();
    }

    public StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto forceExitSafeMode(StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto.newBuilder().setExitedSafeMode(this.impl.forceExitSafeMode()).build();
    }

    public StorageContainerLocationProtocolProtos.StartReplicationManagerResponseProto startReplicationManager(StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request) throws IOException {
        this.impl.startReplicationManager();
        return StorageContainerLocationProtocolProtos.StartReplicationManagerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.StopReplicationManagerResponseProto stopReplicationManager(StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request) throws IOException {
        this.impl.stopReplicationManager();
        return StorageContainerLocationProtocolProtos.StopReplicationManagerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto getReplicationManagerStatus(StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto.newBuilder().setIsRunning(this.impl.getReplicationManagerStatus()).build();
    }

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto request) throws IOException {
        Optional<Object> threshold = Optional.empty();
        Optional<Object> idleiterations = Optional.empty();
        Optional<Object> maxDatanodesRatioToInvolvePerIteration = Optional.empty();
        Optional<Object> maxSizeToMovePerIterationInGB = Optional.empty();
        Optional<Object> maxSizeEnteringTargetInGB = Optional.empty();
        Optional<Object> maxSizeLeavingSourceInGB = Optional.empty();
        if (request.hasThreshold()) {
            threshold = Optional.of(request.getThreshold());
        }
        if (request.hasIdleiterations()) {
            idleiterations = Optional.of(request.getIdleiterations());
        }
        if (request.hasMaxDatanodesRatioToInvolvePerIteration()) {
            maxDatanodesRatioToInvolvePerIteration = Optional.of(request.getMaxDatanodesRatioToInvolvePerIteration());
        }
        if (request.hasMaxSizeToMovePerIterationInGB()) {
            maxSizeToMovePerIterationInGB = Optional.of(request.getMaxSizeToMovePerIterationInGB());
        }
        if (request.hasMaxSizeEnteringTargetInGB()) {
            maxSizeEnteringTargetInGB = Optional.of(request.getMaxSizeEnteringTargetInGB());
        }
        if (request.hasMaxSizeLeavingSourceInGB()) {
            maxSizeLeavingSourceInGB = Optional.of(request.getMaxSizeLeavingSourceInGB());
        }
        return StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto.newBuilder().setStart(this.impl.startContainerBalancer(threshold, idleiterations, maxDatanodesRatioToInvolvePerIteration, maxSizeToMovePerIterationInGB, maxSizeEnteringTargetInGB, maxSizeLeavingSourceInGB)).build();
    }

    public StorageContainerLocationProtocolProtos.StopContainerBalancerResponseProto stopContainerBalancer(StorageContainerLocationProtocolProtos.StopContainerBalancerRequestProto request) throws IOException {
        this.impl.stopContainerBalancer();
        return StorageContainerLocationProtocolProtos.StopContainerBalancerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ContainerBalancerStatusResponseProto getContainerBalancerStatus(StorageContainerLocationProtocolProtos.ContainerBalancerStatusRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ContainerBalancerStatusResponseProto.newBuilder().setIsRunning(this.impl.getContainerBalancerStatus()).build();
    }

    public StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto decommissionNodes(StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto request) throws IOException {
        List errors = this.impl.decommissionNodes(request.getHostsList());
        StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto.Builder response = StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto.newBuilder();
        for (DatanodeAdminError e : errors) {
            StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.Builder error = StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.newBuilder();
            error.setHost(e.getHostname());
            error.setError(e.getError());
            response.addFailedHosts(error);
        }
        return response.build();
    }

    public StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto recommissionNodes(StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto request) throws IOException {
        List errors = this.impl.recommissionNodes(request.getHostsList());
        StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto.Builder response = StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto.newBuilder();
        for (DatanodeAdminError e : errors) {
            StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.Builder error = StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.newBuilder();
            error.setHost(e.getHostname());
            error.setError(e.getError());
            response.addFailedHosts(error);
        }
        return response.build();
    }

    public StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto startMaintenanceNodes(StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto request) throws IOException {
        List errors = this.impl.startMaintenanceNodes(request.getHostsList(), (int)request.getEndInHours());
        StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto.Builder response = StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto.newBuilder();
        for (DatanodeAdminError e : errors) {
            StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.Builder error = StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.newBuilder();
            error.setHost(e.getHostname());
            error.setError(e.getError());
            response.addFailedHosts(error);
        }
        return response.build();
    }

    public StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto getDatanodeUsageInfo(StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request) throws IOException {
        List infoList = request.hasUuid() || request.hasIpaddress() ? this.impl.getDatanodeUsageInfo(request.getIpaddress(), request.getUuid()) : this.impl.getDatanodeUsageInfo(request.getMostUsed(), request.getCount());
        return StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto.newBuilder().addAllInfo((Iterable)infoList).build();
    }
}

