/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableRatisContainerProvider
implements WritableContainerProvider<ReplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(WritableRatisContainerProvider.class);
    private final ConfigurationSource conf;
    private final PipelineManager pipelineManager;
    private final PipelineChoosePolicy pipelineChoosePolicy;
    private final ContainerManager containerManager;

    public WritableRatisContainerProvider(ConfigurationSource conf, PipelineManager pipelineManager, ContainerManager containerManager, PipelineChoosePolicy pipelineChoosePolicy) {
        this.conf = conf;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.pipelineChoosePolicy = pipelineChoosePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerInfo getContainer(long size, ReplicationConfig repConfig, String owner, ExcludeList excludeList) throws IOException {
        ContainerInfo containerInfo = null;
        while (true) {
            List<Pipeline> availablePipelines;
            this.pipelineManager.acquireReadLock();
            try {
                availablePipelines = this.pipelineManager.getPipelines(repConfig, Pipeline.PipelineState.OPEN, excludeList.getDatanodes(), excludeList.getPipelineIds());
                if (availablePipelines.size() == 0 && !excludeList.isEmpty()) {
                    availablePipelines = this.pipelineManager.getPipelines(repConfig, Pipeline.PipelineState.OPEN);
                }
                if (availablePipelines.size() != 0) {
                    containerInfo = this.selectContainer(availablePipelines, size, owner, excludeList);
                }
                if (containerInfo != null) {
                    ContainerInfo containerInfo2 = containerInfo;
                    return containerInfo2;
                }
            }
            finally {
                this.pipelineManager.releaseReadLock();
            }
            if (availablePipelines.size() != 0) continue;
            try {
                Pipeline pipeline = this.pipelineManager.createPipeline(repConfig);
                this.pipelineManager.waitPipelineReady(pipeline.getId(), 0L);
            }
            catch (SCMException se) {
                LOG.warn("Pipeline creation failed for repConfig {} Datanodes may be used up.", (Object)repConfig, (Object)se);
                break;
            }
            catch (IOException e) {
                LOG.warn("Pipeline creation failed for repConfig: {}. Retrying get pipelines call once.", (Object)repConfig, (Object)e);
            }
            this.pipelineManager.acquireReadLock();
            try {
                availablePipelines = this.pipelineManager.getPipelines(repConfig, Pipeline.PipelineState.OPEN, excludeList.getDatanodes(), excludeList.getPipelineIds());
                if (availablePipelines.size() == 0 && !excludeList.isEmpty()) {
                    availablePipelines = this.pipelineManager.getPipelines(repConfig, Pipeline.PipelineState.OPEN);
                }
                if (availablePipelines.size() != 0) {
                    containerInfo = this.selectContainer(availablePipelines, size, owner, excludeList);
                    if (containerInfo == null) continue;
                    ContainerInfo containerInfo3 = containerInfo;
                    return containerInfo3;
                }
                LOG.info("Could not find available pipeline of repConfig: {} even after retrying", (Object)repConfig);
            }
            finally {
                this.pipelineManager.releaseReadLock();
                continue;
            }
            break;
        }
        LOG.error("Unable to allocate a block for the size: {}, repConfig: {}", (Object)size, (Object)repConfig);
        return null;
    }

    private ContainerInfo selectContainer(List<Pipeline> availablePipelines, long size, String owner, ExcludeList excludeList) {
        PipelineRequestInformation pri = PipelineRequestInformation.Builder.getBuilder().setSize(size).build();
        Pipeline pipeline = this.pipelineChoosePolicy.choosePipeline(availablePipelines, pri);
        ContainerInfo containerInfo = this.containerManager.getMatchingContainer(size, owner, pipeline, excludeList.getContainerIds());
        return containerInfo;
    }
}

