/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerProvider;
import org.apache.hadoop.hdds.scm.pipeline.WritableRatisContainerProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;

public class WritableContainerFactory {
    private final WritableContainerProvider<ReplicationConfig> ratisProvider;
    private final WritableContainerProvider<ReplicationConfig> standaloneProvider;

    public WritableContainerFactory(StorageContainerManager scm) {
        this.ratisProvider = new WritableRatisContainerProvider((ConfigurationSource)scm.getConfiguration(), scm.getPipelineManager(), scm.getContainerManager(), scm.getPipelineChoosePolicy());
        this.standaloneProvider = this.ratisProvider;
    }

    public ContainerInfo getContainer(long size, ReplicationConfig repConfig, String owner, ExcludeList excludeList) throws IOException {
        switch (repConfig.getReplicationType()) {
            case STAND_ALONE: {
                return this.standaloneProvider.getContainer(size, repConfig, owner, excludeList);
            }
            case RATIS: {
                return this.ratisProvider.getContainer(size, repConfig, owner, excludeList);
            }
        }
        throw new IOException(repConfig.getReplicationType() + " is an invalid replication type");
    }
}

