/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.InsufficientDatanodesException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;

public class SimplePipelineProvider
extends PipelineProvider<StandaloneReplicationConfig> {
    public SimplePipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager) {
        super(nodeManager, stateManager);
    }

    @Override
    public Pipeline create(StandaloneReplicationConfig replicationConfig) throws IOException {
        List<DatanodeDetails> dns = this.pickNodesNotUsed(replicationConfig);
        if (dns.size() < replicationConfig.getRequiredNodes()) {
            String e = String.format("Cannot create pipeline of factor %d using %d nodes.", replicationConfig.getRequiredNodes(), dns.size());
            throw new InsufficientDatanodesException(e);
        }
        Collections.shuffle(dns);
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setReplicationConfig((ReplicationConfig)replicationConfig).setNodes(dns.subList(0, replicationConfig.getReplicationFactor().getNumber())).build();
    }

    @Override
    public Pipeline create(StandaloneReplicationConfig replicationConfig, List<DatanodeDetails> nodes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setReplicationConfig((ReplicationConfig)replicationConfig).setNodes(nodes).build();
    }

    @Override
    public void close(Pipeline pipeline) throws IOException {
    }

    @Override
    public void shutdown() {
    }
}

