/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineActionHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode> {
    public static final Logger LOG = LoggerFactory.getLogger(PipelineActionHandler.class);
    private final PipelineManager pipelineManager;
    private final SCMContext scmContext;
    private final ConfigurationSource ozoneConf;

    public PipelineActionHandler(PipelineManager pipelineManager, SCMContext scmContext, OzoneConfiguration conf) {
        this.pipelineManager = pipelineManager;
        this.scmContext = scmContext;
        this.ozoneConf = conf;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode report, EventPublisher publisher) {
        ((StorageContainerDatanodeProtocolProtos.PipelineActionsProto)report.getReport()).getPipelineActionsList().forEach(action -> this.processPipelineAction(report.getDatanodeDetails(), (StorageContainerDatanodeProtocolProtos.PipelineAction)action, publisher));
    }

    private void processPipelineAction(DatanodeDetails datanode, StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction, EventPublisher publisher) {
        StorageContainerDatanodeProtocolProtos.ClosePipelineInfo info = pipelineAction.getClosePipeline();
        StorageContainerDatanodeProtocolProtos.PipelineAction.Action action = pipelineAction.getAction();
        PipelineID pid = PipelineID.getFromProtobuf((HddsProtos.PipelineID)info.getPipelineID());
        try {
            LOG.info("Received pipeline action {} for {} from datanode {}. Reason : {}", new Object[]{action, pid, datanode.getUuidString(), info.getDetailedReason()});
            if (action == StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE) {
                this.pipelineManager.closePipeline(this.pipelineManager.getPipeline(pid), false);
            } else {
                LOG.error("unknown pipeline action:{}", (Object)action);
            }
        }
        catch (PipelineNotFoundException e) {
            LOG.warn("Pipeline action {} received for unknown pipeline {}, firing close pipeline event.", (Object)action, (Object)pid);
            ClosePipelineCommand command = new ClosePipelineCommand(pid);
            try {
                command.setTerm(this.scmContext.getTermOfLeader());
            }
            catch (NotLeaderException nle) {
                LOG.warn("Skip sending ClosePipelineCommand for pipeline {}, since not leader SCM.", (Object)pid);
                return;
            }
            publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(datanode.getUuid(), (SCMCommand)command));
        }
        catch (IOException ioe) {
            LOG.error("Could not execute pipeline action={} pipeline={}", new Object[]{action, pid, ioe});
        }
    }
}

