/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.iterators.LoopingIterator;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.pipeline.BackgroundPipelineCreator;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundPipelineCreatorV2
implements SCMService {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundPipelineCreator.class);
    private final PipelineManager pipelineManager;
    private final ConfigurationSource conf;
    private final SCMContext scmContext;
    private final Lock serviceLock = new ReentrantLock();
    private SCMService.ServiceStatus serviceStatus = SCMService.ServiceStatus.PAUSING;
    private final boolean createPipelineInSafeMode;
    private final long waitTimeInMillis;
    private long lastTimeToBeReadyInMillis = 0L;
    private boolean oneShotRun = false;
    private Thread thread;
    private final Object monitor = new Object();
    private static final String THREAD_NAME = "RatisPipelineUtilsThread";
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final long intervalInMillis;

    BackgroundPipelineCreatorV2(PipelineManager pipelineManager, ConfigurationSource conf, SCMServiceManager serviceManager, SCMContext scmContext) {
        this.pipelineManager = pipelineManager;
        this.conf = conf;
        this.scmContext = scmContext;
        this.createPipelineInSafeMode = conf.getBoolean("hdds.scm.safemode.pipeline.creation", true);
        this.waitTimeInMillis = conf.getTimeDuration("hdds.scm.wait.time.after.safemode.exit", "5m", TimeUnit.MILLISECONDS);
        this.intervalInMillis = conf.getTimeDuration("ozone.scm.pipeline.creation.interval", "120s", TimeUnit.MILLISECONDS);
        serviceManager.register(this);
        this.start();
    }

    @Override
    public void start() {
        if (!this.running.compareAndSet(false, true)) {
            LOG.warn("{} is already started, just ignore.", (Object)THREAD_NAME);
            return;
        }
        LOG.info("Starting {}.", (Object)THREAD_NAME);
        this.thread = new ThreadFactoryBuilder().setDaemon(false).setNameFormat("RatisPipelineUtilsThread - %d").setUncaughtExceptionHandler((t, ex) -> {
            this.scmContext.getScm().stop();
            String message = "Terminate SCM, encounter uncaught exception in RatisPipelineUtilsThread";
            ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
        }).build().newThread(this::run);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.running.compareAndSet(true, false)) {
            LOG.warn("{} is not running, just ignore.", (Object)THREAD_NAME);
            return;
        }
        LOG.info("Stopping {}.", (Object)THREAD_NAME);
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted during join {}.", (Object)THREAD_NAME);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (this.running.get()) {
            if (this.shouldRun()) {
                this.createPipelines();
            }
            try {
                Object object = this.monitor;
                synchronized (object) {
                    if (!this.isOneShotRunNeeded()) {
                        this.monitor.wait(this.intervalInMillis);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.warn("{} is interrupted.", (Object)THREAD_NAME);
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean skipCreation(ReplicationConfig replicationConfig, boolean autoCreate) {
        if (replicationConfig.getReplicationType().equals((Object)HddsProtos.ReplicationType.RATIS)) {
            return RatisReplicationConfig.hasFactor((ReplicationConfig)replicationConfig, (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE) && !autoCreate;
        }
        if (replicationConfig.getReplicationType().equals((Object)HddsProtos.ReplicationType.STAND_ALONE)) {
            return ((StandaloneReplicationConfig)replicationConfig).getReplicationFactor() != HddsProtos.ReplicationFactor.ONE;
        }
        return true;
    }

    private void createPipelines() throws RuntimeException {
        HddsProtos.ReplicationType type = HddsProtos.ReplicationType.valueOf((String)this.conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        boolean autoCreateFactorOne = this.conf.getBoolean("ozone.scm.pipeline.creation.auto.factor.one", true);
        ArrayList<ReplicationConfig> list = new ArrayList<ReplicationConfig>();
        for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
            ReplicationConfig replicationConfig = ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor);
            if (this.skipCreation(replicationConfig, autoCreateFactorOne)) continue;
            list.add(replicationConfig);
            if (this.pipelineManager.getSafeModeStatus()) continue;
            try {
                this.pipelineManager.scrubPipeline(replicationConfig);
            }
            catch (IOException e) {
                LOG.error("Error while scrubbing pipelines.", (Throwable)e);
            }
        }
        LoopingIterator it = new LoopingIterator(list);
        while (it.hasNext()) {
            ReplicationConfig replicationConfig = (ReplicationConfig)it.next();
            try {
                this.pipelineManager.createPipeline(replicationConfig);
            }
            catch (IOException ioe) {
                it.remove();
            }
            catch (Throwable t) {
                LOG.error("Error while creating pipelines", t);
                it.remove();
            }
        }
        LOG.debug("BackgroundPipelineCreator createPipelines finished.");
    }

    @Override
    public void notifyStatusChanged() {
        this.serviceLock.lock();
        try {
            if (this.scmContext.isLeaderReady() && (!this.scmContext.isInSafeMode() || this.createPipelineInSafeMode)) {
                if (this.serviceStatus != SCMService.ServiceStatus.RUNNING) {
                    LOG.info("Service {} transitions to RUNNING.", (Object)this.getServiceName());
                    this.lastTimeToBeReadyInMillis = Time.monotonicNow();
                    this.serviceStatus = SCMService.ServiceStatus.RUNNING;
                }
            } else {
                this.serviceStatus = SCMService.ServiceStatus.PAUSING;
            }
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEventTriggered(SCMService.Event event) {
        if (!this.scmContext.isLeader()) {
            LOG.info("ignore, not leader SCM.");
            return;
        }
        if (event == SCMService.Event.NEW_NODE_HANDLER_TRIGGERED || event == SCMService.Event.UNHEALTHY_TO_HEALTHY_NODE_HANDLER_TRIGGERED || event == SCMService.Event.PRE_CHECK_COMPLETED) {
            LOG.info("trigger a one-shot run on {}.", (Object)THREAD_NAME);
            this.serviceLock.lock();
            try {
                this.oneShotRun = true;
            }
            finally {
                this.serviceLock.unlock();
            }
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    @Override
    public boolean shouldRun() {
        this.serviceLock.lock();
        try {
            if (this.oneShotRun) {
                this.oneShotRun = false;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.serviceStatus == SCMService.ServiceStatus.RUNNING && (this.createPipelineInSafeMode || Time.monotonicNow() - this.lastTimeToBeReadyInMillis >= this.waitTimeInMillis);
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    private boolean isOneShotRunNeeded() {
        this.serviceLock.lock();
        try {
            boolean bl = this.oneShotRun;
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public String getServiceName() {
        return BackgroundPipelineCreator.class.getSimpleName();
    }
}

