/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.iterators.LoopingIterator;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.utils.Scheduler;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackgroundPipelineCreator {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundPipelineCreator.class);
    private final Scheduler scheduler;
    private final AtomicBoolean isPipelineCreatorRunning;
    private final PipelineManager pipelineManager;
    private final ConfigurationSource conf;
    private ScheduledFuture<?> periodicTask;
    private AtomicBoolean pausePipelineCreation;

    BackgroundPipelineCreator(PipelineManager pipelineManager, Scheduler scheduler, ConfigurationSource conf) {
        this.pipelineManager = pipelineManager;
        this.conf = conf;
        this.scheduler = scheduler;
        this.pausePipelineCreation = new AtomicBoolean(false);
        this.isPipelineCreatorRunning = new AtomicBoolean(false);
    }

    public void pause() {
        this.pausePipelineCreation.set(true);
    }

    public void resume() {
        this.pausePipelineCreation.set(false);
    }

    private boolean shouldSchedulePipelineCreator() {
        return this.isPipelineCreatorRunning.compareAndSet(false, true);
    }

    synchronized void startFixedIntervalPipelineCreator() {
        if (this.periodicTask != null) {
            return;
        }
        long intervalInMillis = this.conf.getTimeDuration("ozone.scm.pipeline.creation.interval", "120s", TimeUnit.MILLISECONDS);
        this.periodicTask = this.scheduler.scheduleWithFixedDelay(() -> {
            if (!this.shouldSchedulePipelineCreator()) {
                return;
            }
            this.createPipelines();
        }, 0L, intervalInMillis, TimeUnit.MILLISECONDS);
    }

    void triggerPipelineCreation() {
        if (!this.shouldSchedulePipelineCreator()) {
            return;
        }
        this.scheduler.schedule(this::createPipelines, 0L, TimeUnit.MILLISECONDS);
    }

    private boolean skipCreation(ReplicationConfig replicationConfig, boolean autoCreate) {
        if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.RATIS) {
            return RatisReplicationConfig.hasFactor((ReplicationConfig)replicationConfig, (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE) && !autoCreate;
        }
        if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.STAND_ALONE) {
            return ((StandaloneReplicationConfig)replicationConfig).getReplicationFactor() == HddsProtos.ReplicationFactor.ONE;
        }
        return true;
    }

    private void createPipelines() throws RuntimeException {
        if (this.pausePipelineCreation.get()) {
            LOG.info("Pipeline Creation is paused.");
            return;
        }
        HddsProtos.ReplicationType type = HddsProtos.ReplicationType.valueOf((String)this.conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        boolean autoCreateFactorOne = this.conf.getBoolean("ozone.scm.pipeline.creation.auto.factor.one", true);
        ArrayList<ReplicationConfig> list = new ArrayList<ReplicationConfig>();
        for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
            ReplicationConfig replicationConfig = ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor);
            if (this.skipCreation(replicationConfig, autoCreateFactorOne)) continue;
            list.add(replicationConfig);
            if (this.pipelineManager.getSafeModeStatus()) continue;
            try {
                this.pipelineManager.scrubPipeline(replicationConfig);
            }
            catch (IOException e) {
                LOG.error("Error while scrubbing pipelines.", (Throwable)e);
            }
        }
        LoopingIterator it = new LoopingIterator(list);
        while (it.hasNext()) {
            ReplicationConfig replicationConfig = (ReplicationConfig)it.next();
            try {
                if (this.scheduler.isClosed()) break;
                this.pipelineManager.createPipeline(replicationConfig);
            }
            catch (IOException ioe) {
                it.remove();
            }
            catch (Throwable t) {
                LOG.error("Error while creating pipelines", t);
                it.remove();
            }
        }
        this.isPipelineCreatorRunning.set(false);
        LOG.debug("BackgroundPipelineCreator createPipelines finished.");
    }
}

