/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleNodeHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(StaleNodeHandler.class);
    private final NodeManager nodeManager;
    private final PipelineManager pipelineManager;
    private final ConfigurationSource conf;

    public StaleNodeHandler(NodeManager nodeManager, PipelineManager pipelineManager, OzoneConfiguration conf) {
        this.nodeManager = nodeManager;
        this.pipelineManager = pipelineManager;
        this.conf = conf;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        Set<PipelineID> pipelineIds = this.nodeManager.getPipelines(datanodeDetails);
        LOG.info("Datanode {} moved to stale state. Finalizing its pipelines {}", (Object)datanodeDetails, pipelineIds);
        for (PipelineID pipelineID : pipelineIds) {
            try {
                Pipeline pipeline = this.pipelineManager.getPipeline(pipelineID);
                this.pipelineManager.closePipeline(pipeline, true);
            }
            catch (IOException e) {
                LOG.info("Could not finalize pipeline={} for dn={}", (Object)pipelineID, (Object)datanodeDetails);
            }
        }
    }
}

