/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Objects;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class NodeStatus {
    private HddsProtos.NodeOperationalState operationalState;
    private HddsProtos.NodeState health;
    private long opStateExpiryEpochSeconds;

    public NodeStatus(HddsProtos.NodeOperationalState operationalState, HddsProtos.NodeState health) {
        this.operationalState = operationalState;
        this.health = health;
        this.opStateExpiryEpochSeconds = 0L;
    }

    public NodeStatus(HddsProtos.NodeOperationalState operationalState, HddsProtos.NodeState health, long opStateExpireEpocSeconds) {
        this.operationalState = operationalState;
        this.health = health;
        this.opStateExpiryEpochSeconds = opStateExpireEpocSeconds;
    }

    public static NodeStatus inServiceHealthy() {
        return new NodeStatus(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.HEALTHY);
    }

    public static NodeStatus inServiceHealthyReadOnly() {
        return new NodeStatus(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.HEALTHY_READONLY);
    }

    public static NodeStatus inServiceStale() {
        return new NodeStatus(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.STALE);
    }

    public static NodeStatus inServiceDead() {
        return new NodeStatus(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.DEAD);
    }

    public boolean isNodeWritable() {
        return this.health == HddsProtos.NodeState.HEALTHY && this.operationalState == HddsProtos.NodeOperationalState.IN_SERVICE;
    }

    public HddsProtos.NodeState getHealth() {
        return this.health;
    }

    public HddsProtos.NodeOperationalState getOperationalState() {
        return this.operationalState;
    }

    public long getOpStateExpiryEpochSeconds() {
        return this.opStateExpiryEpochSeconds;
    }

    public boolean operationalStateExpired() {
        if (0L == this.opStateExpiryEpochSeconds) {
            return false;
        }
        return System.currentTimeMillis() / 1000L >= this.opStateExpiryEpochSeconds;
    }

    public boolean isDecommission() {
        return this.operationalState == HddsProtos.NodeOperationalState.DECOMMISSIONING || this.operationalState == HddsProtos.NodeOperationalState.DECOMMISSIONED;
    }

    public boolean isDecommissioning() {
        return this.operationalState == HddsProtos.NodeOperationalState.DECOMMISSIONING;
    }

    public boolean isDecommissioned() {
        return this.operationalState == HddsProtos.NodeOperationalState.DECOMMISSIONED;
    }

    public boolean isMaintenance() {
        return this.operationalState == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE || this.operationalState == HddsProtos.NodeOperationalState.IN_MAINTENANCE;
    }

    public boolean isEnteringMaintenance() {
        return this.operationalState == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE;
    }

    public boolean isInMaintenance() {
        return this.operationalState == HddsProtos.NodeOperationalState.IN_MAINTENANCE;
    }

    public boolean isHealthy() {
        return this.health == HddsProtos.NodeState.HEALTHY;
    }

    public boolean isAlive() {
        return this.health == HddsProtos.NodeState.HEALTHY || this.health == HddsProtos.NodeState.STALE;
    }

    public boolean isDead() {
        return this.health == HddsProtos.NodeState.DEAD;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStatus other = (NodeStatus)obj;
        return this.operationalState == other.operationalState && this.health == other.health && this.opStateExpiryEpochSeconds == other.opStateExpiryEpochSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.health, this.operationalState, this.opStateExpiryEpochSeconds);
    }

    public String toString() {
        return "OperationalState: " + this.operationalState + " Health: " + this.health + " OperationStateExpiry: " + this.opStateExpiryEpochSeconds;
    }
}

