/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthyReadOnlyNodeHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(HealthyReadOnlyNodeHandler.class);
    private final PipelineManager pipelineManager;
    private final NodeManager nodeManager;
    private final ConfigurationSource conf;

    public HealthyReadOnlyNodeHandler(NodeManager nodeManager, PipelineManager pipelineManager, OzoneConfiguration conf) {
        this.pipelineManager = pipelineManager;
        this.nodeManager = nodeManager;
        this.conf = conf;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        LOG.info("Datanode {} moved to HEALTHY READONLY state.", (Object)datanodeDetails);
        Set<PipelineID> pipelineIDs = this.nodeManager.getPipelines(datanodeDetails);
        for (PipelineID id : pipelineIDs) {
            LOG.info("Closing pipeline {} which uses HEALTHY READONLY datanode {} ", (Object)id, (Object)datanodeDetails);
            try {
                this.pipelineManager.closePipeline(this.pipelineManager.getPipeline(id), false);
            }
            catch (IOException ex) {
                LOG.error("Failed to close pipeline {} which uses HEALTHY READONLY datanode {}: ", new Object[]{id, datanodeDetails, ex});
            }
        }
        NetworkTopology nt = this.nodeManager.getClusterNetworkTopologyMap();
        if (!nt.contains((Node)datanodeDetails)) {
            nt.add((Node)datanodeDetails);
            Preconditions.checkNotNull((Object)this.nodeManager.getNodeByUuid(datanodeDetails.getUuidString()).getParent());
        }
    }
}

