/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.util.Time;

public class DatanodeInfo
extends DatanodeDetails {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile long lastHeartbeatTime = Time.monotonicNow();
    private long lastStatsUpdatedTime;
    private List<StorageContainerDatanodeProtocolProtos.StorageReportProto> storageReports;
    private List<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> metadataStorageReports;
    private StorageContainerDatanodeProtocolProtos.LayoutVersionProto lastKnownLayoutVersion;
    private NodeStatus nodeStatus;

    public DatanodeInfo(DatanodeDetails datanodeDetails, NodeStatus nodeStatus, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo) {
        super(datanodeDetails);
        this.lastKnownLayoutVersion = UpgradeUtils.toLayoutVersionProto((int)(layoutInfo != null ? layoutInfo.getMetadataLayoutVersion() : 0), (int)(layoutInfo != null ? layoutInfo.getSoftwareLayoutVersion() : 0));
        this.storageReports = Collections.emptyList();
        this.nodeStatus = nodeStatus;
        this.metadataStorageReports = Collections.emptyList();
    }

    public void updateLastHeartbeatTime() {
        this.updateLastHeartbeatTime(Time.monotonicNow());
    }

    @VisibleForTesting
    public void updateLastHeartbeatTime(long milliSecondsSinceEpoch) {
        try {
            this.lock.writeLock().lock();
            this.lastHeartbeatTime = milliSecondsSinceEpoch;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updateLastKnownLayoutVersion(StorageContainerDatanodeProtocolProtos.LayoutVersionProto version) {
        if (version == null) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.lastKnownLayoutVersion = UpgradeUtils.toLayoutVersionProto((int)version.getMetadataLayoutVersion(), (int)version.getSoftwareLayoutVersion());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getLastHeartbeatTime() {
        try {
            this.lock.readLock().lock();
            long l = this.lastHeartbeatTime;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StorageContainerDatanodeProtocolProtos.LayoutVersionProto getLastKnownLayoutVersion() {
        try {
            this.lock.readLock().lock();
            StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutVersionProto = this.lastKnownLayoutVersion;
            return layoutVersionProto;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void updateStorageReports(List<StorageContainerDatanodeProtocolProtos.StorageReportProto> reports) {
        try {
            this.lock.writeLock().lock();
            this.lastStatsUpdatedTime = Time.monotonicNow();
            this.storageReports = reports;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updateMetaDataStorageReports(List<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> reports) {
        try {
            this.lock.writeLock().lock();
            this.lastStatsUpdatedTime = Time.monotonicNow();
            this.metadataStorageReports = reports;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<StorageContainerDatanodeProtocolProtos.StorageReportProto> getStorageReports() {
        try {
            this.lock.readLock().lock();
            List<StorageContainerDatanodeProtocolProtos.StorageReportProto> list = this.storageReports;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> getMetadataStorageReports() {
        try {
            this.lock.readLock().lock();
            List<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> list = this.metadataStorageReports;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getHealthyVolumeCount() {
        try {
            this.lock.readLock().lock();
            int n = this.storageReports.size() - this.getFailedVolumeCount();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getMetaDataVolumeCount() {
        try {
            this.lock.readLock().lock();
            int n = this.metadataStorageReports.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private int getFailedVolumeCount() {
        return (int)this.storageReports.stream().filter(e -> e.hasFailed() ? e.getFailed() : false).count();
    }

    public long getLastStatsUpdatedTime() {
        return this.lastStatsUpdatedTime;
    }

    public NodeStatus getNodeStatus() {
        try {
            this.lock.readLock().lock();
            NodeStatus nodeStatus = this.nodeStatus;
            return nodeStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setNodeStatus(NodeStatus newNodeStatus) {
        try {
            this.lock.writeLock().lock();
            this.nodeStatus = newNodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

