/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.MoveDataNodePair;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.certificate.CertInfo;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMMetadataStoreImpl
implements SCMMetadataStore {
    private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTable;
    private Table<BigInteger, X509Certificate> validCertsTable;
    private Table<BigInteger, X509Certificate> validSCMCertsTable;
    private Table<BigInteger, X509Certificate> revokedCertsTable;
    private Table<BigInteger, CertInfo> revokedCertsV2Table;
    private Table<ContainerID, ContainerInfo> containerTable;
    private Table<PipelineID, Pipeline> pipelineTable;
    private Table<String, TransactionInfo> transactionInfoTable;
    private Table<Long, CRLInfo> crlInfoTable;
    private Table<String, Long> crlSequenceIdTable;
    private Table<String, Long> sequenceIdTable;
    private Table<ContainerID, MoveDataNodePair> moveTable;
    private static final Logger LOG = LoggerFactory.getLogger(SCMMetadataStoreImpl.class);
    private DBStore store;
    private final OzoneConfiguration configuration;

    public SCMMetadataStoreImpl(OzoneConfiguration config) throws IOException {
        this.configuration = config;
        this.start(this.configuration);
    }

    public void start(OzoneConfiguration config) throws IOException {
        if (this.store == null) {
            File metaDir = HAUtils.getMetaDir((DBDefinition)new SCMDBDefinition(), (OzoneConfiguration)this.configuration);
            File markerFile = new File(metaDir, "dbInconsistentMarker");
            if (markerFile.exists()) {
                LOG.error("File {} marks that SCM DB is in an inconsistent state.", (Object)markerFile);
                String errorMsg = "Cannot load SCM DB as it is in an inconsistent state.";
                ExitUtils.terminate((int)1, (String)errorMsg, (Logger)LOG);
            }
            this.store = DBStoreBuilder.createDBStore((ConfigurationSource)config, (DBDefinition)new SCMDBDefinition());
            this.deletedBlocksTable = SCMDBDefinition.DELETED_BLOCKS.getTable(this.store);
            this.checkTableStatus(this.deletedBlocksTable, SCMDBDefinition.DELETED_BLOCKS.getName());
            this.validCertsTable = SCMDBDefinition.VALID_CERTS.getTable(this.store);
            this.checkTableStatus(this.validCertsTable, SCMDBDefinition.VALID_CERTS.getName());
            this.validSCMCertsTable = SCMDBDefinition.VALID_SCM_CERTS.getTable(this.store);
            this.checkTableStatus(this.validSCMCertsTable, SCMDBDefinition.VALID_SCM_CERTS.getName());
            this.revokedCertsTable = SCMDBDefinition.REVOKED_CERTS.getTable(this.store);
            this.checkTableStatus(this.revokedCertsTable, SCMDBDefinition.REVOKED_CERTS.getName());
            this.revokedCertsV2Table = SCMDBDefinition.REVOKED_CERTS_V2.getTable(this.store);
            this.checkTableStatus(this.revokedCertsV2Table, SCMDBDefinition.REVOKED_CERTS_V2.getName());
            this.pipelineTable = SCMDBDefinition.PIPELINES.getTable(this.store);
            this.checkTableStatus(this.pipelineTable, SCMDBDefinition.PIPELINES.getName());
            this.containerTable = SCMDBDefinition.CONTAINERS.getTable(this.store);
            this.checkTableStatus(this.containerTable, SCMDBDefinition.CONTAINERS.getName());
            this.transactionInfoTable = SCMDBDefinition.TRANSACTIONINFO.getTable(this.store);
            this.checkTableStatus(this.transactionInfoTable, SCMDBDefinition.TRANSACTIONINFO.getName());
            this.crlInfoTable = SCMDBDefinition.CRLS.getTable(this.store);
            this.crlSequenceIdTable = SCMDBDefinition.CRL_SEQUENCE_ID.getTable(this.store);
            this.sequenceIdTable = SCMDBDefinition.SEQUENCE_ID.getTable(this.store);
            this.checkTableStatus(this.sequenceIdTable, SCMDBDefinition.SEQUENCE_ID.getName());
            this.moveTable = SCMDBDefinition.MOVE.getTable(this.store);
            this.checkTableStatus(this.moveTable, SCMDBDefinition.MOVE.getName());
        }
    }

    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public DBStore getStore() {
        return this.store;
    }

    public Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeletedBlocksTXTable() {
        return this.deletedBlocksTable;
    }

    public Table<BigInteger, X509Certificate> getValidCertsTable() {
        return this.validCertsTable;
    }

    public Table<BigInteger, X509Certificate> getValidSCMCertsTable() {
        return this.validSCMCertsTable;
    }

    public Table<BigInteger, X509Certificate> getRevokedCertsTable() {
        return this.revokedCertsTable;
    }

    public Table<BigInteger, CertInfo> getRevokedCertsV2Table() {
        return this.revokedCertsV2Table;
    }

    public Table<Long, CRLInfo> getCRLInfoTable() {
        return this.crlInfoTable;
    }

    public Table<String, Long> getCRLSequenceIdTable() {
        return this.crlSequenceIdTable;
    }

    public TableIterator getAllCerts(CertificateStore.CertType certType) {
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            return this.validCertsTable.iterator();
        }
        if (certType == CertificateStore.CertType.REVOKED_CERTS) {
            return this.revokedCertsTable.iterator();
        }
        return null;
    }

    public Table<PipelineID, Pipeline> getPipelineTable() {
        return this.pipelineTable;
    }

    public Table<String, TransactionInfo> getTransactionInfoTable() {
        return this.transactionInfoTable;
    }

    public BatchOperationHandler getBatchHandler() {
        return this.store;
    }

    public Table<ContainerID, ContainerInfo> getContainerTable() {
        return this.containerTable;
    }

    public Table<String, Long> getSequenceIdTable() {
        return this.sequenceIdTable;
    }

    public Table<ContainerID, MoveDataNodePair> getMoveTable() {
        return this.moveTable;
    }

    private void checkTableStatus(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logs for more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }
}

