/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.cert.CertificateException;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.x509.certificate.CertInfo;
import org.apache.hadoop.hdds.utils.db.Codec;

public class CertInfoCodec
implements Codec<CertInfo> {
    public byte[] toPersistedFormat(CertInfo certInfo) throws IOException {
        return certInfo.getProtobuf().toByteArray();
    }

    public CertInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't be converted to real object.");
        try {
            return CertInfo.fromProtobuf((HddsProtos.CertInfoProto)((HddsProtos.CertInfoProto)HddsProtos.CertInfoProto.PARSER.parseFrom(rawData)));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public CertInfo copyObject(CertInfo object) {
        throw new UnsupportedOperationException();
    }
}

