/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.ReflectionUtil;
import org.apache.hadoop.hdds.scm.ha.io.Codec;
import org.apache.hadoop.hdds.scm.ha.io.CodecFactory;

public class ListCodec
implements Codec {
    @Override
    public ByteString serialize(Object object) throws InvalidProtocolBufferException {
        SCMRatisProtocol.ListArgument.Builder listArgs = SCMRatisProtocol.ListArgument.newBuilder();
        List values = (List)object;
        if (!values.isEmpty()) {
            Class<?> type = values.get(0).getClass();
            listArgs.setType(type.getName());
            for (Object value : values) {
                listArgs.addValue(CodecFactory.getCodec(type).serialize(value));
            }
        } else {
            listArgs.setType(Object.class.getName());
        }
        return listArgs.build().toByteString();
    }

    @Override
    public Object deserialize(Class<?> type, ByteString value) throws InvalidProtocolBufferException {
        try {
            List result = (List)type.newInstance();
            SCMRatisProtocol.ListArgument listArgs = (SCMRatisProtocol.ListArgument)ReflectionUtil.getMethod(SCMRatisProtocol.ListArgument.class, "parseFrom", byte[].class).invoke(null, new Object[]{value.toByteArray()});
            Class<?> dataType = ReflectionUtil.getClass(listArgs.getType());
            for (ByteString element : listArgs.getValueList()) {
                result.add(CodecFactory.getCodec(dataType).deserialize(dataType, element));
            }
            return result;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new InvalidProtocolBufferException("GeneratedMessage cannot be decoded: " + ex.getMessage());
        }
    }
}

