/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha.io;

import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolMessageEnum;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hdds.scm.ha.ReflectionUtil;
import org.apache.hadoop.hdds.scm.ha.io.Codec;

public class EnumCodec
implements Codec {
    @Override
    public ByteString serialize(Object object) throws InvalidProtocolBufferException {
        return ByteString.copyFrom((byte[])Ints.toByteArray((int)((ProtocolMessageEnum)object).getNumber()));
    }

    @Override
    public Object deserialize(Class<?> type, ByteString value) throws InvalidProtocolBufferException {
        try {
            return ReflectionUtil.getMethod(type, "valueOf", Integer.TYPE).invoke(null, Ints.fromByteArray((byte[])value.toByteArray()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new InvalidProtocolBufferException("GeneratedMessage cannot be decoded!" + ex.getMessage());
        }
    }
}

