/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha.io;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolMessageEnum;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.ha.io.BigIntegerCodec;
import org.apache.hadoop.hdds.scm.ha.io.BooleanCodec;
import org.apache.hadoop.hdds.scm.ha.io.Codec;
import org.apache.hadoop.hdds.scm.ha.io.EnumCodec;
import org.apache.hadoop.hdds.scm.ha.io.GeneratedMessageCodec;
import org.apache.hadoop.hdds.scm.ha.io.ListCodec;
import org.apache.hadoop.hdds.scm.ha.io.LongCodec;
import org.apache.hadoop.hdds.scm.ha.io.StringCodec;
import org.apache.hadoop.hdds.scm.ha.io.X509CertificateCodec;

public final class CodecFactory {
    private static Map<Class<?>, Codec> codecs = new HashMap();

    private CodecFactory() {
    }

    public static Codec getCodec(Class<?> type) throws InvalidProtocolBufferException {
        ArrayList classes = new ArrayList();
        classes.add(type);
        classes.add(type.getSuperclass());
        classes.addAll(Arrays.asList(type.getInterfaces()));
        for (Class clazz : classes) {
            if (!codecs.containsKey(clazz)) continue;
            return codecs.get(clazz);
        }
        throw new InvalidProtocolBufferException("Codec for " + type + " not found!");
    }

    static {
        codecs.put(GeneratedMessage.class, new GeneratedMessageCodec());
        codecs.put(ProtocolMessageEnum.class, new EnumCodec());
        codecs.put(List.class, new ListCodec());
        codecs.put(Long.class, new LongCodec());
        codecs.put(String.class, new StringCodec());
        codecs.put(Boolean.class, new BooleanCodec());
        codecs.put(BigInteger.class, new BigIntegerCodec());
        codecs.put(X509Certificate.class, new X509CertificateCodec());
    }
}

