/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.ha.InterSCMGrpcClient;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SCMSnapshotProvider.class);
    private final File scmSnapshotDir;
    private final ConfigurationSource conf;
    private Map<String, SCMNodeDetails> peerNodesMap;
    private final SCMCertificateClient scmCertificateClient;

    public SCMSnapshotProvider(ConfigurationSource conf, List<SCMNodeDetails> peerNodes, SCMCertificateClient scmCertificateClient) {
        LOG.info("Initializing SCM Snapshot Provider");
        this.conf = conf;
        this.scmCertificateClient = scmCertificateClient;
        String scmRatisDirectory = SCMHAUtils.getSCMRatisDirectory((ConfigurationSource)conf);
        if (scmRatisDirectory == null || scmRatisDirectory.isEmpty()) {
            throw new IllegalArgumentException("ozone.metadata.dirs must be defined.");
        }
        HddsUtils.createDir((String)scmRatisDirectory);
        this.scmSnapshotDir = HddsUtils.createDir((String)SCMHAUtils.getSCMRatisSnapshotDirectory((ConfigurationSource)conf));
        if (peerNodes != null) {
            this.peerNodesMap = new HashMap<String, SCMNodeDetails>();
            for (SCMNodeDetails peerNode : peerNodes) {
                this.peerNodesMap.put(peerNode.getNodeId(), peerNode);
            }
        }
    }

    @VisibleForTesting
    public void setPeerNodesMap(Map<String, SCMNodeDetails> peerNodesMap) {
        this.peerNodesMap = peerNodesMap;
    }

    public DBCheckpoint getSCMDBSnapshot(String leaderSCMNodeID) throws IOException {
        String snapshotTime = Long.toString(System.currentTimeMillis());
        String snapshotFileName = "scm.db-" + leaderSCMNodeID + "-" + snapshotTime;
        String snapshotFilePath = Paths.get(this.scmSnapshotDir.getAbsolutePath(), snapshotFileName).toFile().getAbsolutePath();
        File targetFile = new File(snapshotFilePath + ".tar.gz");
        int port = this.peerNodesMap.get(leaderSCMNodeID).getGrpcPort();
        String host = this.peerNodesMap.get(leaderSCMNodeID).getInetAddress().getHostAddress();
        try (InterSCMGrpcClient downloadClient = new InterSCMGrpcClient(host, port, this.conf, this.scmCertificateClient);){
            downloadClient.download(targetFile.toPath()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Rocks DB checkpoint downloading failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        Path untarredDbDir = Paths.get(snapshotFilePath, new String[0]);
        FileUtil.unTar((File)targetFile, (File)untarredDbDir.toFile());
        FileUtils.deleteQuietly((File)targetFile);
        LOG.info("Successfully downloaded latest checkpoint from leader SCM: {} path {}", (Object)leaderSCMNodeID, (Object)untarredDbDir.toAbsolutePath());
        RocksDBCheckpoint scmCheckpoint = new RocksDBCheckpoint(untarredDbDir);
        return scmCheckpoint;
    }

    @VisibleForTesting
    public File getScmSnapshotDir() {
        return this.scmSnapshotDir;
    }
}

