/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.ReflectionUtil;
import org.apache.hadoop.hdds.scm.ha.io.CodecFactory;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public final class SCMRatisRequest {
    private final SCMRatisProtocol.RequestType type;
    private final String operation;
    private final Object[] arguments;
    private final Class<?>[] parameterTypes;

    private SCMRatisRequest(SCMRatisProtocol.RequestType type, String operation, Class<?>[] parameterTypes, Object ... arguments) {
        this.type = type;
        this.operation = operation;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    public static SCMRatisRequest of(SCMRatisProtocol.RequestType type, String operation, Class<?>[] parameterTypes, Object ... arguments) {
        Preconditions.checkState((parameterTypes.length == arguments.length ? 1 : 0) != 0);
        return new SCMRatisRequest(type, operation, parameterTypes, arguments);
    }

    public SCMRatisProtocol.RequestType getType() {
        return this.type;
    }

    public String getOperation() {
        return this.operation;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Message encode() throws InvalidProtocolBufferException {
        SCMRatisProtocol.SCMRatisRequestProto.Builder requestProtoBuilder = SCMRatisProtocol.SCMRatisRequestProto.newBuilder();
        requestProtoBuilder.setType(this.type);
        SCMRatisProtocol.Method.Builder methodBuilder = SCMRatisProtocol.Method.newBuilder();
        methodBuilder.setName(this.operation);
        ArrayList<SCMRatisProtocol.MethodArgument> args = new ArrayList<SCMRatisProtocol.MethodArgument>();
        int paramCounter = 0;
        for (Object argument : this.arguments) {
            SCMRatisProtocol.MethodArgument.Builder argBuilder = SCMRatisProtocol.MethodArgument.newBuilder();
            argBuilder.setType(this.parameterTypes[paramCounter++].getName());
            argBuilder.setValue(CodecFactory.getCodec(argument.getClass()).serialize(argument));
            args.add(argBuilder.build());
        }
        methodBuilder.addAllArgs(args);
        requestProtoBuilder.setMethod(methodBuilder.build());
        return Message.valueOf((ByteString)ByteString.copyFrom((byte[])requestProtoBuilder.build().toByteArray()));
    }

    public static SCMRatisRequest decode(Message message) throws InvalidProtocolBufferException {
        SCMRatisProtocol.SCMRatisRequestProto requestProto = SCMRatisProtocol.SCMRatisRequestProto.parseFrom((byte[])message.getContent().toByteArray());
        SCMRatisProtocol.Method method = requestProto.getMethod();
        ArrayList<Object> args = new ArrayList<Object>();
        Class[] parameterTypes = new Class[method.getArgsCount()];
        int paramCounter = 0;
        for (SCMRatisProtocol.MethodArgument argument : method.getArgsList()) {
            try {
                Class<?> clazz = ReflectionUtil.getClass(argument.getType());
                parameterTypes[paramCounter++] = clazz;
                args.add(CodecFactory.getCodec(clazz).deserialize(clazz, argument.getValue()));
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidProtocolBufferException(argument.getType() + " cannot be decoded!" + ex.getMessage());
            }
        }
        return new SCMRatisRequest(requestProto.getType(), method.getName(), parameterTypes, args.toArray());
    }
}

