/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.HASecurityUtils;
import org.apache.hadoop.hdds.scm.ha.SCMRatisRequest;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.Replicate;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMHAInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SCMHAInvocationHandler.class);
    private final SCMRatisProtocol.RequestType requestType;
    private final Object localHandler;
    private final SCMRatisServer ratisHandler;

    public SCMHAInvocationHandler(SCMRatisProtocol.RequestType requestType, Object localHandler, SCMRatisServer ratisHandler) {
        this.requestType = requestType;
        this.localHandler = localHandler;
        this.ratisHandler = ratisHandler;
        if (ratisHandler != null) {
            ratisHandler.registerStateMachineHandler(requestType, localHandler);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            long startTime = Time.monotonicNow();
            Object result = this.ratisHandler != null && method.isAnnotationPresent(Replicate.class) ? this.invokeRatis(method, args) : this.invokeLocal(method, args);
            LOG.debug("Call: {} took {} ms", (Object)method, (Object)(Time.monotonicNow() - startTime));
            return result;
        }
        catch (InvocationTargetException iEx) {
            throw iEx.getCause();
        }
    }

    private Object invokeLocal(Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        LOG.trace("Invoking method {} on target {} with arguments {}", new Object[]{method, this.localHandler, args});
        return method.invoke(this.localHandler, args);
    }

    private Object invokeRatis(Method method, Object[] args) throws Exception {
        long startTime = Time.monotonicNowNanos();
        Preconditions.checkNotNull((Object)this.ratisHandler);
        SCMRatisRequest scmRatisRequest = SCMRatisRequest.of(this.requestType, method.getName(), method.getParameterTypes(), args);
        SCMRatisResponse response = method.getName().equals("storeValidCertificate") && args[args.length - 1].equals(HddsProtos.NodeType.SCM) ? HASecurityUtils.submitScmCertsToRatis(this.ratisHandler.getDivision().getGroup(), this.ratisHandler.getGrpcTlsConfig(), scmRatisRequest.encode()) : this.ratisHandler.submitRequest(scmRatisRequest);
        LOG.info("Invoking method {} on target {}, cost {}us", new Object[]{method, this.ratisHandler, (double)(Time.monotonicNowNanos() - startTime) / 1000.0});
        if (response.isSuccess()) {
            return response.getResult();
        }
        throw response.getException();
    }
}

