/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.statemachine.SnapshotInfo;

public class SCMHADBTransactionBufferImpl
implements SCMHADBTransactionBuffer {
    private final StorageContainerManager scm;
    private SCMMetadataStore metadataStore;
    private BatchOperation currentBatchOperation;
    private TransactionInfo latestTrxInfo;
    private SnapshotInfo latestSnapshot;

    public SCMHADBTransactionBufferImpl(StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.init();
    }

    private BatchOperation getCurrentBatchOperation() {
        return this.currentBatchOperation;
    }

    public <KEY, VALUE> void addToBuffer(Table<KEY, VALUE> table, KEY key, VALUE value) throws IOException {
        table.putWithBatch(this.getCurrentBatchOperation(), key, value);
    }

    public <KEY, VALUE> void removeFromBuffer(Table<KEY, VALUE> table, KEY key) throws IOException {
        table.deleteWithBatch(this.getCurrentBatchOperation(), key);
    }

    @Override
    public void updateLatestTrxInfo(TransactionInfo info) {
        if (info.compareTo(this.latestTrxInfo) <= 0) {
            throw new IllegalArgumentException("Updating DB buffer transaction info by an older transaction info, current: " + this.latestTrxInfo + ", updating to: " + info);
        }
        this.latestTrxInfo = info;
    }

    @Override
    public TransactionInfo getLatestTrxInfo() {
        return this.latestTrxInfo;
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        return this.latestSnapshot;
    }

    @Override
    public void setLatestSnapshot(SnapshotInfo latestSnapshot) {
        this.latestSnapshot = latestSnapshot;
    }

    @Override
    public void flush() throws IOException {
        Table transactionInfoTable = this.metadataStore.getTransactionInfoTable();
        transactionInfoTable.putWithBatch(this.currentBatchOperation, (Object)"#TRANSACTIONINFO", (Object)this.latestTrxInfo);
        this.metadataStore.getStore().commitBatchOperation(this.currentBatchOperation);
        this.currentBatchOperation.close();
        this.latestSnapshot = this.latestTrxInfo.toSnapshotInfo();
        this.currentBatchOperation = this.metadataStore.getStore().initBatchOperation();
        DeletedBlockLog deletedBlockLog = this.scm.getScmBlockManager().getDeletedBlockLog();
        Preconditions.checkArgument((boolean)(deletedBlockLog instanceof DeletedBlockLogImpl));
        ((DeletedBlockLogImpl)deletedBlockLog).onFlush();
    }

    @Override
    public void init() throws IOException {
        this.metadataStore = this.scm.getScmMetadataStore();
        this.currentBatchOperation = this.metadataStore.getStore().initBatchOperation();
        this.latestTrxInfo = (TransactionInfo)this.metadataStore.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
        if (this.latestTrxInfo == null) {
            this.latestTrxInfo = TransactionInfo.builder().setTransactionIndex(-1L).setCurrentTerm(0L).build();
        }
        this.latestSnapshot = this.latestTrxInfo.toSnapshotInfo();
    }

    public String toString() {
        return this.latestTrxInfo.toString();
    }

    public void close() throws IOException {
    }
}

