/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMDBCheckpointProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SCMDBCheckpointProvider.class);
    private transient DBStore scmDbStore;

    public SCMDBCheckpointProvider(DBStore scmDbStore) {
        this.scmDbStore = scmDbStore;
    }

    public void writeDBCheckPointToSream(OutputStream stream, boolean flush) throws IOException {
        LOG.info("Received request to obtain SCM DB checkpoint snapshot");
        if (this.scmDbStore == null) {
            LOG.error("Unable to process checkpointing request. DB Store is null");
            return;
        }
        DBCheckpoint checkpoint = null;
        try {
            checkpoint = this.scmDbStore.getCheckpoint(flush);
            if (checkpoint == null || checkpoint.getCheckpointLocation() == null) {
                throw new IOException("Unable to process metadata snapshot request. Checkpoint request returned null.");
            }
            Path file = checkpoint.getCheckpointLocation().getFileName();
            if (file == null) {
                return;
            }
            Instant start = Instant.now();
            HddsServerUtil.writeDBCheckpointToStream((DBCheckpoint)checkpoint, (OutputStream)stream);
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("Time taken to write the checkpoint to response output stream: {} milliseconds", (Object)duration);
        }
        catch (IOException ioe) {
            LOG.error("Unable to process metadata snapshot request. ", (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (checkpoint != null) {
                try {
                    checkpoint.cleanupCheckpoint();
                }
                catch (IOException e) {
                    LOG.error("Error trying to clean checkpoint at {} .", (Object)checkpoint.getCheckpointLocation().toString());
                }
            }
        }
    }
}

