/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.ha.MockSCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMRatisRequest;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMSnapshotProvider;
import org.apache.hadoop.hdds.scm.ha.SCMStateMachine;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;

public final class MockSCMHAManager
implements SCMHAManager {
    private final SCMRatisServer ratisServer = new MockRatisServer();
    private boolean isLeader;
    private DBTransactionBuffer transactionBuffer;

    public static SCMHAManager getInstance(boolean isLeader) {
        return new MockSCMHAManager(isLeader);
    }

    public static SCMHAManager getInstance(boolean isLeader, DBTransactionBuffer buffer) {
        return new MockSCMHAManager(isLeader, buffer);
    }

    private MockSCMHAManager(boolean isLeader) {
        this(isLeader, new MockSCMHADBTransactionBuffer());
    }

    private MockSCMHAManager(boolean isLeader, DBTransactionBuffer buffer) {
        this.isLeader = isLeader;
        this.transactionBuffer = buffer;
    }

    @Override
    public void start() throws IOException {
        this.ratisServer.start();
    }

    boolean isLeader() {
        return this.isLeader;
    }

    public void setIsLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    @Override
    public SCMRatisServer getRatisServer() {
        return this.ratisServer;
    }

    @Override
    public DBTransactionBuffer getDBTransactionBuffer() {
        return this.transactionBuffer;
    }

    @Override
    public SCMHADBTransactionBuffer asSCMHADBTransactionBuffer() {
        return null;
    }

    @Override
    public SCMSnapshotProvider getSCMSnapshotProvider() {
        return null;
    }

    @Override
    public void shutdown() throws IOException {
        this.ratisServer.stop();
    }

    @Override
    public boolean addSCM(AddSCMRequest request) throws IOException {
        return false;
    }

    @Override
    public DBCheckpoint downloadCheckpointFromLeader(String leaderId) {
        return null;
    }

    @Override
    public TermIndex verifyCheckpointFromLeader(String leaderId, DBCheckpoint checkpoint) {
        return null;
    }

    @Override
    public TermIndex installCheckpoint(DBCheckpoint dbCheckpoint) {
        return null;
    }

    private class MockRatisServer
    implements SCMRatisServer {
        private Map<SCMRatisProtocol.RequestType, Object> handlers = new EnumMap<SCMRatisProtocol.RequestType, Object>(SCMRatisProtocol.RequestType.class);

        private MockRatisServer() {
        }

        @Override
        public void start() {
        }

        @Override
        public void registerStateMachineHandler(SCMRatisProtocol.RequestType handlerType, Object handler) {
            this.handlers.put(handlerType, handler);
        }

        @Override
        public SCMRatisResponse submitRequest(SCMRatisRequest request) throws IOException {
            RaftClientReply reply;
            RaftGroupMemberId raftId = RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"peer"), (RaftGroupId)RaftGroupId.randomId());
            if (MockSCMHAManager.this.isLeader()) {
                try {
                    Message result = this.process(request);
                    reply = RaftClientReply.newBuilder().setClientId(ClientId.randomId()).setServerId(raftId).setGroupId(RaftGroupId.emptyGroupId()).setCallId(1L).setSuccess(true).setMessage(result).setException(null).setLogIndex(1L).build();
                }
                catch (Exception ex) {
                    reply = RaftClientReply.newBuilder().setClientId(ClientId.randomId()).setServerId(raftId).setGroupId(RaftGroupId.emptyGroupId()).setCallId(1L).setSuccess(false).setMessage(Message.EMPTY).setException((RaftException)new StateMachineException(raftId, (Throwable)ex)).setLogIndex(1L).build();
                }
            } else {
                reply = RaftClientReply.newBuilder().setClientId(ClientId.randomId()).setServerId(raftId).setGroupId(RaftGroupId.emptyGroupId()).setCallId(1L).setSuccess(false).setMessage(Message.EMPTY).setException((RaftException)this.triggerNotLeaderException()).setLogIndex(1L).build();
            }
            return SCMRatisResponse.decode(reply);
        }

        private Message process(SCMRatisRequest request) throws Exception {
            try {
                Object handler = this.handlers.get(request.getType());
                if (handler == null) {
                    throw new IOException("No handler found for request type " + request.getType());
                }
                ArrayList argumentTypes = new ArrayList();
                for (Object args : request.getArguments()) {
                    argumentTypes.add(args.getClass());
                }
                Object result = handler.getClass().getMethod(request.getOperation(), argumentTypes.toArray(new Class[0])).invoke(handler, request.getArguments());
                return SCMRatisResponse.encode(result);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new InvalidProtocolBufferException(ex.getMessage());
            }
            catch (InvocationTargetException e) {
                Exception targetEx = (Exception)e.getTargetException();
                throw targetEx != null ? targetEx : e;
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public RaftServer.Division getDivision() {
            return null;
        }

        @Override
        public List<String> getRatisRoles() {
            return Arrays.asList("180.3.14.5:9894", "180.3.14.21:9894", "180.3.14.145:9894");
        }

        @Override
        public NotLeaderException triggerNotLeaderException() {
            return new NotLeaderException(RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"peer"), (RaftGroupId)RaftGroupId.randomId()), null, new ArrayList());
        }

        @Override
        public SCMStateMachine getSCMStateMachine() {
            return null;
        }

        @Override
        public boolean addSCM(AddSCMRequest request) throws IOException {
            return false;
        }

        @Override
        public GrpcTlsConfig getGrpcTlsConfig() {
            return null;
        }
    }
}

