/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.statemachine.SnapshotInfo;

public class MockSCMHADBTransactionBuffer
implements SCMHADBTransactionBuffer {
    private DBStore dbStore;
    private BatchOperation currentBatchOperation;

    public MockSCMHADBTransactionBuffer() {
    }

    public MockSCMHADBTransactionBuffer(DBStore store) {
        this.dbStore = store;
    }

    private BatchOperation getCurrentBatchOperation() {
        if (this.currentBatchOperation == null) {
            this.currentBatchOperation = this.dbStore != null ? this.dbStore.initBatchOperation() : new RDBBatchOperation();
        }
        return this.currentBatchOperation;
    }

    public <KEY, VALUE> void addToBuffer(Table<KEY, VALUE> table, KEY key, VALUE value) throws IOException {
        table.putWithBatch(this.getCurrentBatchOperation(), key, value);
    }

    public <KEY, VALUE> void removeFromBuffer(Table<KEY, VALUE> table, KEY key) throws IOException {
        table.deleteWithBatch(this.getCurrentBatchOperation(), key);
    }

    @Override
    public void updateLatestTrxInfo(TransactionInfo info) {
    }

    @Override
    public TransactionInfo getLatestTrxInfo() {
        return null;
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        return null;
    }

    @Override
    public void setLatestSnapshot(SnapshotInfo latestSnapshot) {
    }

    @Override
    public void flush() throws IOException {
        if (this.dbStore != null) {
            this.dbStore.commitBatchOperation(this.getCurrentBatchOperation());
            this.currentBatchOperation.close();
            this.currentBatchOperation = null;
        }
    }

    @Override
    public void init() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
    }
}

