/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.ha.InterSCMGrpcService;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.ForwardingServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterSCMGrpcProtocolService {
    private static final Logger LOG = LoggerFactory.getLogger(InterSCMGrpcService.class);
    private final int port;
    private Server server;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public InterSCMGrpcProtocolService(ConfigurationSource conf, StorageContainerManager scm) {
        Preconditions.checkNotNull((Object)conf);
        this.port = conf.getInt("ozone.scm.grpc.port", 9895);
        NettyServerBuilder nettyServerBuilder = ((NettyServerBuilder)ServerBuilder.forPort((int)this.port)).maxInboundMessageSize(0x2000000);
        InterSCMGrpcService service = new InterSCMGrpcService(scm);
        ForwardingServerBuilder b = nettyServerBuilder.addService((BindableService)service);
        SecurityConfig securityConfig = new SecurityConfig(conf);
        if (securityConfig.isSecurityEnabled() && securityConfig.isGrpcTlsEnabled()) {
            try {
                SslContextBuilder sslServerContextBuilder = SslContextBuilder.forServer((PrivateKey)scm.getScmCertificateClient().getPrivateKey(), (X509Certificate[])new X509Certificate[]{scm.getScmCertificateClient().getCertificate()});
                SslContextBuilder sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslServerContextBuilder, (SslProvider)securityConfig.getGrpcSslProvider());
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                LOG.error("Unable to setup TLS for secure InterSCMGrpcProtocolService GRPC endpoint.", (Throwable)ex);
                throw new RuntimeException("Unable to setup TLS for secure InterSCMGrpcProtocolService GRPC endpoint.");
            }
        }
        Preconditions.checkNotNull((Object)b);
        this.server = nettyServerBuilder.build();
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws IOException {
        if (!this.isStarted.compareAndSet(false, true)) {
            LOG.info("Ignore. already started.");
            return;
        }
        LOG.info("Starting SCM Grpc Service at port {}", (Object)this.port);
        this.server.start();
    }

    public void stop() {
        if (this.isStarted.get()) {
            this.server.shutdown();
            try {
                this.server.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("failed to shutdown XceiverServerGrpc", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.isStarted.set(false);
        }
    }
}

