/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.certificate.authority.DefaultCAServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.DefaultCAProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.util.TimeDuration;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HASecurityUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HASecurityUtils.class);

    private HASecurityUtils() {
    }

    public static void initializeSecurity(SCMStorageConfig scmStorageConfig, OzoneConfiguration conf, InetSocketAddress scmAddress, boolean primaryscm) throws IOException {
        LOG.info("Initializing secure StorageContainerManager.");
        SCMCertificateClient certClient = new SCMCertificateClient(new SecurityConfig((ConfigurationSource)conf));
        CertificateClient.InitResponse response = certClient.init();
        LOG.info("Init response: {}", (Object)response);
        switch (response) {
            case SUCCESS: {
                LOG.info("Initialization successful.");
                break;
            }
            case GETCERT: {
                if (!primaryscm) {
                    HASecurityUtils.getRootCASignedSCMCert((CertificateClient)certClient, conf, scmStorageConfig, scmAddress);
                } else {
                    HASecurityUtils.getPrimarySCMSelfSignedCert((CertificateClient)certClient, conf, scmStorageConfig, scmAddress);
                }
                LOG.info("Successfully stored SCM signed certificate.");
                break;
            }
            case FAILURE: {
                LOG.error("SCM security initialization failed.");
                throw new RuntimeException("OM security initialization failed.");
            }
            case RECOVER: {
                LOG.error("SCM security initialization failed. SCM certificate is missing.");
                throw new RuntimeException("SCM security initialization failed.");
            }
            default: {
                LOG.error("SCM security initialization failed. Init response: {}", (Object)response);
                throw new RuntimeException("SCM security initialization failed.");
            }
        }
    }

    private static void getRootCASignedSCMCert(CertificateClient client, OzoneConfiguration config, SCMStorageConfig scmStorageConfig, InetSocketAddress scmAddress) {
        try {
            PKCS10CertificationRequest csr = HASecurityUtils.generateCSR(client, scmStorageConfig, config, scmAddress);
            HddsProtos.ScmNodeDetailsProto scmNodeDetailsProto = HddsProtos.ScmNodeDetailsProto.newBuilder().setClusterId(scmStorageConfig.getClusterID()).setHostName(scmAddress.getHostName()).setScmNodeId(scmStorageConfig.getScmId()).build();
            SCMSecurityProtocolClientSideTranslatorPB secureScmClient = HddsServerUtil.getScmSecurityClientWithFixedDuration((OzoneConfiguration)config);
            SCMSecurityProtocolProtos.SCMGetCertResponseProto response = secureScmClient.getSCMCertChain(scmNodeDetailsProto, CertificateSignRequest.getEncodedString((PKCS10CertificationRequest)csr));
            String pemEncodedCert = response.getX509Certificate();
            if (!response.hasX509CACertificate()) {
                throw new RuntimeException("Unable to retrieve SCM certificate chain");
            }
            String pemEncodedRootCert = response.getX509CACertificate();
            client.storeCertificate(pemEncodedRootCert, true, true);
            client.storeCertificate(pemEncodedCert, true);
            X509Certificate certificate = CertificateCodec.getX509Certificate((String)pemEncodedCert);
            HASecurityUtils.persistSubCACertificate(config, client, CertificateCodec.getCertificateHolder((X509Certificate)certificate));
            scmStorageConfig.setScmCertSerialId(certificate.getSerialNumber().toString());
        }
        catch (IOException | CertificateException e) {
            LOG.error("Error while fetching/storing SCM signed certificate.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void getPrimarySCMSelfSignedCert(CertificateClient client, OzoneConfiguration config, SCMStorageConfig scmStorageConfig, InetSocketAddress scmAddress) {
        try {
            CertificateServer rootCAServer = HASecurityUtils.initializeRootCertificateServer(config, null, scmStorageConfig, (PKIProfile)new DefaultCAProfile());
            PKCS10CertificationRequest csr = HASecurityUtils.generateCSR(client, scmStorageConfig, config, scmAddress);
            X509CertificateHolder subSCMCertHolder = (X509CertificateHolder)rootCAServer.requestCertificate(csr, CertificateApprover.ApprovalType.KERBEROS_TRUSTED, HddsProtos.NodeType.SCM).get();
            X509CertificateHolder rootCACertificateHolder = rootCAServer.getCACertificate();
            String pemEncodedCert = CertificateCodec.getPEMEncodedString((X509CertificateHolder)subSCMCertHolder);
            String pemEncodedRootCert = CertificateCodec.getPEMEncodedString((X509CertificateHolder)rootCACertificateHolder);
            client.storeCertificate(pemEncodedRootCert, true, true);
            client.storeCertificate(pemEncodedCert, true);
            HASecurityUtils.persistSubCACertificate(config, client, subSCMCertHolder);
            scmStorageConfig.setScmCertSerialId(subSCMCertHolder.getSerialNumber().toString());
        }
        catch (IOException | InterruptedException | CertificateException | ExecutionException e) {
            LOG.error("Error while fetching/storing SCM signed certificate.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static CertificateServer initializeRootCertificateServer(OzoneConfiguration config, CertificateStore scmCertStore, SCMStorageConfig scmStorageConfig, PKIProfile pkiProfile) throws IOException {
        String subject = "scm@" + InetAddress.getLocalHost().getHostName();
        DefaultCAServer rootCAServer = new DefaultCAServer(subject, scmStorageConfig.getClusterID(), scmStorageConfig.getScmId(), scmCertStore, pkiProfile, OzoneConsts.SCM_ROOT_CA_COMPONENT_NAME);
        rootCAServer.init(new SecurityConfig((ConfigurationSource)config), CertificateServer.CAType.SELF_SIGNED_CA);
        return rootCAServer;
    }

    private static PKCS10CertificationRequest generateCSR(CertificateClient client, SCMStorageConfig scmStorageConfig, OzoneConfiguration config, InetSocketAddress scmAddress) throws IOException {
        CertificateSignRequest.Builder builder = client.getCSRBuilder();
        KeyPair keyPair = new KeyPair(client.getPublicKey(), client.getPrivateKey());
        String hostname = scmAddress.getAddress().getHostName();
        String subject = "scm-sub@" + hostname;
        builder.setKey(keyPair).setConfiguration((ConfigurationSource)config).setScmID(scmStorageConfig.getScmId()).setClusterID(scmStorageConfig.getClusterID()).setSubject(subject);
        LOG.info("Creating csr for SCM->hostName:{},scmId:{},clusterId:{},subject:{}", new Object[]{hostname, scmStorageConfig.getScmId(), scmStorageConfig.getClusterID(), subject});
        return builder.build();
    }

    private static void persistSubCACertificate(OzoneConfiguration config, CertificateClient certificateClient, X509CertificateHolder certificateHolder) throws IOException {
        CertificateCodec certCodec = new CertificateCodec(new SecurityConfig((ConfigurationSource)config), certificateClient.getComponentName());
        certCodec.writeCertificate(certificateHolder);
    }

    public static Parameters createSCMServerTlsParameters(GrpcTlsConfig grpcTlsConfig) {
        Parameters parameters = new Parameters();
        if (grpcTlsConfig != null) {
            GrpcConfigKeys.Server.setTlsConf((Parameters)parameters, (GrpcTlsConfig)grpcTlsConfig);
            GrpcConfigKeys.Admin.setTlsConf((Parameters)parameters, (GrpcTlsConfig)grpcTlsConfig);
            GrpcConfigKeys.Client.setTlsConf((Parameters)parameters, (GrpcTlsConfig)grpcTlsConfig);
            GrpcConfigKeys.TLS.setConf((Parameters)parameters, (GrpcTlsConfig)grpcTlsConfig);
        }
        return parameters;
    }

    public static GrpcTlsConfig createSCMRatisTLSConfig(SecurityConfig conf, CertificateClient certificateClient) {
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            return new GrpcTlsConfig(certificateClient.getPrivateKey(), certificateClient.getCertificate(), certificateClient.getCACertificate(), true);
        }
        return null;
    }

    public static SCMRatisResponse submitScmCertsToRatis(RaftGroup raftGroup, GrpcTlsConfig tlsConfig, Message message) throws Exception {
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)RpcType.valueOf((String)"GRPC"));
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(raftGroup).setLeaderId(null).setProperties(properties).setRetryPolicy((RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)120, (TimeDuration)TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS)));
        if (tlsConfig != null) {
            Parameters parameters = new Parameters();
            GrpcConfigKeys.Client.setTlsConf((Parameters)parameters, (GrpcTlsConfig)tlsConfig);
            builder.setParameters(parameters);
        }
        RaftClient raftClient = builder.build();
        CompletableFuture future = raftClient.async().send(message);
        RaftClientReply raftClientReply = (RaftClientReply)future.get();
        return SCMRatisResponse.decode(raftClientReply);
    }
}

