/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import org.apache.hadoop.hdds.scm.ha.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionUtil<E extends Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionUtil.class);
    private final CheckedFunction<E> fn;
    private CheckedFunction<E> onException;
    private volatile boolean completed;

    private ExecutionUtil(CheckedFunction<E> fn) {
        this.fn = fn;
        this.completed = false;
    }

    public static <E extends Exception> ExecutionUtil<E> create(CheckedFunction<E> tryBlock) {
        return new ExecutionUtil<E>(tryBlock);
    }

    public ExecutionUtil<E> onException(CheckedFunction<E> catchBlock) {
        this.onException = catchBlock;
        return this;
    }

    public void execute() throws E {
        if (!this.completed) {
            this.completed = true;
            try {
                this.fn.execute();
            }
            catch (Exception ex) {
                try {
                    this.onException.execute();
                }
                catch (Exception error) {
                    LOG.warn("Got error while doing clean-up.", (Throwable)error);
                }
                throw ex;
            }
        }
    }
}

