/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="Replication Manager Metrics", context="ozone")
public final class ReplicationManagerMetrics
implements MetricsSource {
    public static final String METRICS_SOURCE_NAME = ReplicationManagerMetrics.class.getSimpleName();
    private static final MetricsInfo INFLIGHT_REPLICATION = Interns.info((String)"InflightReplication", (String)"Tracked inflight container replication requests.");
    private static final MetricsInfo INFLIGHT_DELETION = Interns.info((String)"InflightDeletion", (String)"Tracked inflight container deletion requests.");
    private static final MetricsInfo INFLIGHT_MOVE = Interns.info((String)"InflightMove", (String)"Tracked inflight container move requests.");
    @Metric(value={"Number of replication commands sent."})
    private MutableCounterLong numReplicationCmdsSent;
    @Metric(value={"Number of replication commands completed."})
    private MutableCounterLong numReplicationCmdsCompleted;
    @Metric(value={"Number of replication commands timeout."})
    private MutableCounterLong numReplicationCmdsTimeout;
    @Metric(value={"Number of deletion commands sent."})
    private MutableCounterLong numDeletionCmdsSent;
    @Metric(value={"Number of deletion commands completed."})
    private MutableCounterLong numDeletionCmdsCompleted;
    @Metric(value={"Number of deletion commands timeout."})
    private MutableCounterLong numDeletionCmdsTimeout;
    @Metric(value={"Number of replication bytes total."})
    private MutableCounterLong numReplicationBytesTotal;
    @Metric(value={"Number of replication bytes completed."})
    private MutableCounterLong numReplicationBytesCompleted;
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    private ReplicationManager replicationManager;

    public ReplicationManagerMetrics(ReplicationManager manager) {
        this.replicationManager = manager;
    }

    public static ReplicationManagerMetrics create(ReplicationManager manager) {
        return (ReplicationManagerMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "SCM Replication manager (closed container replication) related metrics", (Object)new ReplicationManagerMetrics(manager));
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(METRICS_SOURCE_NAME).addGauge(INFLIGHT_REPLICATION, this.getInflightReplication()).addGauge(INFLIGHT_DELETION, this.getInflightDeletion()).addGauge(INFLIGHT_MOVE, this.getInflightMove());
        this.numReplicationCmdsSent.snapshot(builder, all);
        this.numReplicationCmdsCompleted.snapshot(builder, all);
        this.numReplicationCmdsTimeout.snapshot(builder, all);
        this.numDeletionCmdsSent.snapshot(builder, all);
        this.numDeletionCmdsCompleted.snapshot(builder, all);
        this.numDeletionCmdsTimeout.snapshot(builder, all);
        this.numReplicationBytesTotal.snapshot(builder, all);
        this.numReplicationBytesCompleted.snapshot(builder, all);
    }

    public void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public void incrNumReplicationCmdsSent() {
        this.numReplicationCmdsSent.incr();
    }

    public void incrNumReplicationCmdsCompleted() {
        this.numReplicationCmdsCompleted.incr();
    }

    public void incrNumReplicationCmdsTimeout() {
        this.numReplicationCmdsTimeout.incr();
    }

    public void incrNumDeletionCmdsSent() {
        this.numDeletionCmdsSent.incr();
    }

    public void incrNumDeletionCmdsCompleted() {
        this.numDeletionCmdsCompleted.incr();
    }

    public void incrNumDeletionCmdsTimeout() {
        this.numDeletionCmdsTimeout.incr();
    }

    public void incrNumReplicationBytesTotal(long bytes) {
        this.numReplicationBytesTotal.incr(bytes);
    }

    public void incrNumReplicationBytesCompleted(long bytes) {
        this.numReplicationBytesCompleted.incr(bytes);
    }

    public long getInflightReplication() {
        return this.replicationManager.getInflightReplication().size();
    }

    public long getInflightDeletion() {
        return this.replicationManager.getInflightDeletion().size();
    }

    public long getInflightMove() {
        return this.replicationManager.getInflightMove().size();
    }

    public long getNumReplicationCmdsSent() {
        return this.numReplicationCmdsSent.value();
    }

    public long getNumReplicationCmdsCompleted() {
        return this.numReplicationCmdsCompleted.value();
    }

    public long getNumReplicationCmdsTimeout() {
        return this.numReplicationCmdsTimeout.value();
    }

    public long getNumDeletionCmdsSent() {
        return this.numDeletionCmdsSent.value();
    }

    public long getNumDeletionCmdsCompleted() {
        return this.numDeletionCmdsCompleted.value();
    }

    public long getNumDeletionCmdsTimeout() {
        return this.numDeletionCmdsTimeout.value();
    }

    public long getNumReplicationBytesTotal() {
        return this.numReplicationBytesTotal.value();
    }

    public long getNumReplicationBytesCompleted() {
        return this.numReplicationBytesCompleted.value();
    }
}

