/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContainerPlacementRackAware
extends SCMCommonPlacementPolicy {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(SCMContainerPlacementRackAware.class);
    private final NetworkTopology networkTopology;
    private boolean fallback;
    private static final int RACK_LEVEL = 1;
    private static final int MAX_RETRY = 3;
    private final SCMContainerPlacementMetrics metrics;
    private static final int REQUIRED_RACKS = 2;

    public SCMContainerPlacementRackAware(NodeManager nodeManager, ConfigurationSource conf, NetworkTopology networkTopology, boolean fallback, SCMContainerPlacementMetrics metrics) {
        super(nodeManager, conf);
        this.networkTopology = networkTopology;
        this.fallback = fallback;
        this.metrics = metrics;
    }

    @Override
    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        DatanodeDetails secondNode;
        DatanodeDetails favoredNode;
        int excludedNodesCount;
        Preconditions.checkArgument((nodesRequired > 0 ? 1 : 0) != 0);
        this.metrics.incrDatanodeRequestCount(nodesRequired);
        int datanodeCount = this.networkTopology.getNumOfLeafNode("");
        int n = excludedNodesCount = excludedNodes == null ? 0 : excludedNodes.size();
        if (datanodeCount < nodesRequired + excludedNodesCount) {
            throw new SCMException("No enough datanodes to choose. TotalNode = " + datanodeCount + " RequiredNode = " + nodesRequired + " ExcludedNode = " + excludedNodesCount, null);
        }
        List<DatanodeDetails> mutableFavoredNodes = favoredNodes;
        if (mutableFavoredNodes != null && excludedNodes != null) {
            mutableFavoredNodes = new ArrayList<DatanodeDetails>();
            mutableFavoredNodes.addAll(favoredNodes);
            mutableFavoredNodes.removeAll(excludedNodes);
        }
        int favoredNodeNum = mutableFavoredNodes == null ? 0 : mutableFavoredNodes.size();
        ArrayList<DatanodeDetails> chosenNodes = new ArrayList<DatanodeDetails>();
        int favorIndex = 0;
        if (excludedNodes == null || excludedNodes.isEmpty()) {
            DatanodeDetails secondNode2;
            DatanodeDetails firstNode;
            DatanodeDetails favoredNode2;
            DatanodeDetails datanodeDetails = favoredNode2 = favoredNodeNum > favorIndex ? mutableFavoredNodes.get(favorIndex) : null;
            if (favoredNode2 != null) {
                firstNode = favoredNode2;
                ++favorIndex;
            } else {
                firstNode = this.chooseNode(null, null, metadataSizeRequired, dataSizeRequired);
            }
            chosenNodes.add(firstNode);
            if (--nodesRequired == 0) {
                return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
            }
            DatanodeDetails datanodeDetails2 = favoredNode2 = favoredNodeNum > favorIndex ? mutableFavoredNodes.get(favorIndex) : null;
            if (favoredNode2 != null && this.networkTopology.isSameParent((Node)firstNode, (Node)favoredNode2)) {
                secondNode2 = favoredNode2;
                ++favorIndex;
            } else {
                secondNode2 = this.chooseNode(chosenNodes, Arrays.asList(firstNode), metadataSizeRequired, dataSizeRequired);
            }
            chosenNodes.add(secondNode2);
            if (--nodesRequired == 0) {
                return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
            }
            return this.chooseNodes(null, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, metadataSizeRequired, dataSizeRequired);
        }
        ArrayList<DatanodeDetails> mutableExcludedNodes = new ArrayList<DatanodeDetails>();
        mutableExcludedNodes.addAll(excludedNodes);
        if (excludedNodes.size() == 1) {
            DatanodeDetails firstNode;
            DatanodeDetails favoredNode3;
            DatanodeDetails datanodeDetails = favoredNode3 = favoredNodeNum > favorIndex ? mutableFavoredNodes.get(favorIndex) : null;
            if (favoredNode3 != null && this.networkTopology.isSameParent((Node)excludedNodes.get(0), (Node)favoredNode3)) {
                firstNode = favoredNode3;
                ++favorIndex;
            } else {
                firstNode = this.chooseNode(mutableExcludedNodes, excludedNodes, metadataSizeRequired, dataSizeRequired);
            }
            chosenNodes.add(firstNode);
            if (--nodesRequired == 0) {
                return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
            }
            return this.chooseNodes(null, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, metadataSizeRequired, dataSizeRequired);
        }
        for (int i = 0; i < excludedNodesCount; ++i) {
            for (int j = i + 1; j < excludedNodesCount; ++j) {
                if (!this.networkTopology.isSameParent((Node)excludedNodes.get(i), (Node)excludedNodes.get(j))) continue;
                return this.chooseNodes(mutableExcludedNodes, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, metadataSizeRequired, dataSizeRequired);
            }
        }
        DatanodeDetails datanodeDetails = favoredNode = favoredNodeNum > favorIndex ? mutableFavoredNodes.get(favorIndex) : null;
        if (favoredNode != null && this.networkTopology.isSameParent((Node)mutableExcludedNodes.get(0), (Node)favoredNode)) {
            secondNode = favoredNode;
            ++favorIndex;
        } else {
            secondNode = this.chooseNode(chosenNodes, mutableExcludedNodes, metadataSizeRequired, dataSizeRequired);
        }
        chosenNodes.add(secondNode);
        mutableExcludedNodes.add(secondNode);
        if (--nodesRequired == 0) {
            return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
        }
        return this.chooseNodes(mutableExcludedNodes, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, metadataSizeRequired, dataSizeRequired);
    }

    @Override
    public DatanodeDetails chooseNode(List<DatanodeDetails> healthyNodes) {
        return null;
    }

    private DatanodeDetails chooseNode(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> affinityNodes, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        int ancestorGen = 1;
        int maxRetry = 3;
        ArrayList<String> excludedNodesForCapacity = null;
        boolean isFallbacked = false;
        while (true) {
            this.metrics.incrDatanodeChooseAttemptCount();
            DatanodeDetails node = null;
            if (affinityNodes != null) {
                Node affinityNode;
                Iterator<DatanodeDetails> iterator = affinityNodes.iterator();
                while (iterator.hasNext() && (node = (DatanodeDetails)this.networkTopology.chooseRandom("", excludedNodesForCapacity, excludedNodes, affinityNode = (Node)iterator.next(), ancestorGen)) == null) {
                }
            } else {
                node = (DatanodeDetails)this.networkTopology.chooseRandom("", excludedNodesForCapacity, excludedNodes, null, ancestorGen);
            }
            if (node == null) {
                LOG.warn("Failed to find the datanode for container. excludedNodes:" + (excludedNodes == null ? "" : excludedNodes.toString()) + ", affinityNode:" + (affinityNodes == null ? "" : affinityNodes.stream().map(Object::toString).collect(Collectors.joining(", "))));
                if (this.fallback) {
                    isFallbacked = true;
                    if (affinityNodes != null) {
                        affinityNodes = null;
                        continue;
                    }
                    if (ancestorGen == 1) {
                        --ancestorGen;
                        continue;
                    }
                }
                throw new SCMException("No satisfied datanode to meet the excludedNodes and affinityNode constrains.", null);
            }
            if (this.isValidNode(node, metadataSizeRequired, dataSizeRequired)) {
                this.metrics.incrDatanodeChooseSuccessCount();
                if (isFallbacked) {
                    this.metrics.incrDatanodeChooseFallbackCount();
                }
                return node;
            }
            if (--maxRetry == 0) {
                String errMsg = "No satisfied datanode to meet the space constrains. metadatadata size required: " + metadataSizeRequired + " data size required: " + dataSizeRequired;
                LOG.info(errMsg);
                throw new SCMException(errMsg, null);
            }
            if (excludedNodesForCapacity == null) {
                excludedNodesForCapacity = new ArrayList<String>();
            }
            excludedNodesForCapacity.add(node.getNetworkFullPath());
        }
    }

    private List<DatanodeDetails> chooseNodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> chosenNodes, List<DatanodeDetails> favoredNodes, int favorIndex, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        Preconditions.checkArgument((chosenNodes != null ? 1 : 0) != 0);
        List<DatanodeDetails> excludedNodeList = excludedNodes != null ? excludedNodes : chosenNodes;
        int favoredNodeNum = favoredNodes == null ? 0 : favoredNodes.size();
        do {
            DatanodeDetails chosenNode;
            DatanodeDetails favoredNode;
            DatanodeDetails datanodeDetails = favoredNode = favoredNodeNum > favorIndex ? favoredNodes.get(favorIndex) : null;
            if (favoredNode != null && this.networkTopology.isSameParent((Node)excludedNodeList.get(excludedNodeList.size() - 1), (Node)favoredNode)) {
                chosenNode = favoredNode;
                ++favorIndex;
            } else {
                chosenNode = this.chooseNode(excludedNodeList, null, metadataSizeRequired, dataSizeRequired);
            }
            excludedNodeList.add(chosenNode);
            if (excludedNodeList == chosenNodes) continue;
            chosenNodes.add(chosenNode);
        } while (--nodesRequired != 0);
        return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
    }

    @Override
    protected int getRequiredRackCount(int numReplicas) {
        return 2;
    }
}

