/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerMoveSelection;
import org.apache.hadoop.hdds.scm.container.balancer.FindTargetStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindTargetGreedy
implements FindTargetStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FindTargetGreedy.class);
    private ContainerManager containerManager;
    private PlacementPolicy placementPolicy;

    public FindTargetGreedy(ContainerManager containerManager, PlacementPolicy placementPolicy) {
        this.containerManager = containerManager;
        this.placementPolicy = placementPolicy;
    }

    @Override
    public ContainerMoveSelection findTargetForContainerMove(DatanodeDetails source, Collection<DatanodeDetails> potentialTargets, Set<ContainerID> candidateContainers, BiFunction<DatanodeDetails, Long, Boolean> canSizeEnterTarget) {
        for (DatanodeDetails target : potentialTargets) {
            for (ContainerID container : candidateContainers) {
                ContainerInfo containerInfo;
                Set<ContainerReplica> replicas;
                try {
                    replicas = this.containerManager.getContainerReplicas(container);
                    containerInfo = this.containerManager.getContainer(container);
                }
                catch (ContainerNotFoundException e) {
                    LOG.warn("Could not get Container {} from Container Manager for obtaining replicas in Container Balancer.", (Object)container, (Object)e);
                    continue;
                }
                if (!replicas.stream().noneMatch(replica -> replica.getDatanodeDetails().equals((Object)target)) || !this.containerMoveSatisfiesPlacementPolicy(container, replicas, source, target) || !canSizeEnterTarget.apply(target, containerInfo.getUsedBytes()).booleanValue()) continue;
                return new ContainerMoveSelection(target, container);
            }
        }
        LOG.info("Container Balancer could not find a target for source datanode {}", (Object)source.getUuidString());
        return null;
    }

    @Override
    public boolean containerMoveSatisfiesPlacementPolicy(ContainerID containerID, Set<ContainerReplica> replicas, DatanodeDetails source, DatanodeDetails target) {
        ContainerInfo containerInfo;
        try {
            containerInfo = this.containerManager.getContainer(containerID);
        }
        catch (ContainerNotFoundException e) {
            LOG.warn("Could not get Container {} from Container Manager while checking if container move satisfies placement policy in Container Balancer.", (Object)containerID.toString(), (Object)e);
            return false;
        }
        List replicaList = replicas.stream().map(ContainerReplica::getDatanodeDetails).filter(datanodeDetails -> !datanodeDetails.equals((Object)source)).collect(Collectors.toList());
        replicaList.add(target);
        ContainerPlacementStatus placementStatus = this.placementPolicy.validateContainerPlacement(replicaList, containerInfo.getReplicationConfig().getRequiredNodes());
        return placementStatus.isPolicySatisfied();
    }
}

