/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import java.util.Comparator;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerBalancerSelectionCriteria {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerBalancerSelectionCriteria.class);
    private ContainerBalancerConfiguration balancerConfiguration;
    private NodeManager nodeManager;
    private ReplicationManager replicationManager;
    private ContainerManager containerManager;
    private Set<ContainerID> selectedContainers;
    private Set<ContainerID> excludeContainers;

    public ContainerBalancerSelectionCriteria(ContainerBalancerConfiguration balancerConfiguration, NodeManager nodeManager, ReplicationManager replicationManager, ContainerManager containerManager) {
        this.balancerConfiguration = balancerConfiguration;
        this.nodeManager = nodeManager;
        this.replicationManager = replicationManager;
        this.containerManager = containerManager;
        this.selectedContainers = new HashSet<ContainerID>();
        this.excludeContainers = balancerConfiguration.getExcludeContainers();
    }

    private boolean isContainerReplicatingOrDeleting(ContainerID containerID) {
        return this.replicationManager.isContainerReplicatingOrDeleting(containerID);
    }

    public NavigableSet<ContainerID> getCandidateContainers(DatanodeDetails node) {
        TreeSet<ContainerID> containerIDSet = new TreeSet<ContainerID>(this.orderContainersByUsedBytes().reversed());
        try {
            containerIDSet.addAll(this.nodeManager.getContainers(node));
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Could not find Datanode {} while selecting candidate containers for Container Balancer.", (Object)node.toString(), (Object)e);
            return containerIDSet;
        }
        if (this.excludeContainers != null) {
            containerIDSet.removeAll(this.excludeContainers);
        }
        if (this.selectedContainers != null) {
            containerIDSet.removeAll(this.selectedContainers);
        }
        containerIDSet.removeIf(containerID -> {
            try {
                return this.containerManager.getContainer((ContainerID)containerID).getState() != HddsProtos.LifeCycleState.CLOSED;
            }
            catch (ContainerNotFoundException e) {
                LOG.warn("Could not retrieve ContainerInfo for container {} for checking LifecycleState in ContainerBalancer. Excluding this container.", (Object)containerID.toString(), (Object)e);
                return true;
            }
        });
        containerIDSet.removeIf(this::isContainerReplicatingOrDeleting);
        return containerIDSet;
    }

    private int isContainerMoreUsed(ContainerID first, ContainerID second) {
        if (first.equals((Object)second)) {
            return 0;
        }
        try {
            ContainerInfo firstInfo = this.containerManager.getContainer(first);
            ContainerInfo secondInfo = this.containerManager.getContainer(second);
            if (firstInfo.getUsedBytes() > secondInfo.getUsedBytes()) {
                return 1;
            }
            return -1;
        }
        catch (ContainerNotFoundException e) {
            LOG.warn("Could not retrieve ContainerInfo from container manager for comparison.", (Throwable)e);
            return 0;
        }
    }

    private Comparator<ContainerID> orderContainersByUsedBytes() {
        return this::isContainerMoreUsed;
    }

    public void setExcludeContainers(Set<ContainerID> excludeContainers) {
        this.excludeContainers = excludeContainers;
    }

    public void setSelectedContainers(Set<ContainerID> selectedContainers) {
        this.selectedContainers = selectedContainers;
    }
}

