/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import org.apache.hadoop.hdds.scm.container.placement.metrics.LongMetric;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;

@Metrics(name="ContainerBalancer Metrics", about="Metrics related to Container Balancer running in SCM", context="SCM")
public final class ContainerBalancerMetrics {
    @Metric(about="The total amount of used space in GigaBytes that needs to be balanced.")
    private LongMetric dataSizeToBalanceGB = new LongMetric(0L);
    @Metric(about="The amount of Giga Bytes that have been moved to achieve balance.")
    private LongMetric dataSizeBalancedGB = new LongMetric(0L);
    @Metric(about="Number of containers that Container Balancer has moved until now.")
    private LongMetric movedContainersNum = new LongMetric(0L);
    @Metric(about="The total number of datanodes that need to be balanced.")
    private LongMetric datanodesNumToBalance = new LongMetric(0L);
    @Metric(about="Number of datanodes that Container Balancer has balanced until now.")
    private LongMetric datanodesNumBalanced = new LongMetric(0L);
    @Metric(about="Utilisation value of the current maximum utilised datanode.")
    private double maxDatanodeUtilizedRatio = 0.0;

    public LongMetric getDataSizeToBalanceGB() {
        return this.dataSizeToBalanceGB;
    }

    public void setDataSizeToBalanceGB(long size) {
        this.dataSizeToBalanceGB = new LongMetric(size);
    }

    public LongMetric getDataSizeBalancedGB() {
        return this.dataSizeBalancedGB;
    }

    public void setDataSizeBalancedGB(LongMetric dataSizeBalancedGB) {
        this.dataSizeBalancedGB = dataSizeBalancedGB;
    }

    public long incrementDataSizeBalancedGB(long valueToAdd) {
        this.dataSizeBalancedGB.add(valueToAdd);
        return this.dataSizeBalancedGB.get();
    }

    public LongMetric getMovedContainersNum() {
        return this.movedContainersNum;
    }

    public void setMovedContainersNum(LongMetric movedContainersNum) {
        this.movedContainersNum = movedContainersNum;
    }

    public long incrementMovedContainersNum(long valueToAdd) {
        this.movedContainersNum.add(valueToAdd);
        return this.movedContainersNum.get();
    }

    public LongMetric getDatanodesNumToBalance() {
        return this.datanodesNumToBalance;
    }

    public void setDatanodesNumToBalance(LongMetric datanodesNumToBalance) {
        this.datanodesNumToBalance = datanodesNumToBalance;
    }

    public LongMetric getDatanodesNumBalanced() {
        return this.datanodesNumBalanced;
    }

    public void setDatanodesNumBalanced(LongMetric datanodesNumBalanced) {
        this.datanodesNumBalanced = datanodesNumBalanced;
    }

    public long incrementDatanodesNumBalanced(long valueToAdd) {
        this.datanodesNumBalanced.add(valueToAdd);
        return this.datanodesNumBalanced.get();
    }

    public double getMaxDatanodeUtilizedRatio() {
        return this.maxDatanodeUtilizedRatio;
    }

    public void setMaxDatanodeUtilizedRatio(double maxDatanodeUtilizedRatio) {
        this.maxDatanodeUtilizedRatio = maxDatanodeUtilizedRatio;
    }
}

