/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.fs.DUFactory;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.container.balancer")
public final class ContainerBalancerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerBalancerConfiguration.class);
    private OzoneConfiguration ozoneConfiguration;
    @Config(key="utilization.threshold", type=ConfigType.AUTO, defaultValue="0.1", tags={ConfigTag.BALANCER}, description="Threshold is a fraction in the range of 0 to 1. A cluster is considered balanced if for each datanode, the utilization of the datanode (used space to capacity ratio) differs from the utilization of the cluster (used space to capacity ratio of the entire cluster) no more than the threshold value.")
    private String threshold = "0.1";
    @Config(key="datanodes.involved.max.ratio.per.iteration", type=ConfigType.AUTO, defaultValue="0.2", tags={ConfigTag.BALANCER}, description="The ratio of maximum number of datanodes that should be involved in balancing in one iteration to the total number of healthy, in service nodes known to container balancer.")
    private String maxDatanodesRatioToInvolvePerIteration = "0.2";
    @Config(key="size.moved.max.per.iteration", type=ConfigType.SIZE, defaultValue="30GB", tags={ConfigTag.BALANCER}, description="The maximum size of data in bytes that will be moved by Container Balancer in one iteration.")
    private long maxSizeToMovePerIteration = 0x780000000L;
    @Config(key="size.entering.target.max", type=ConfigType.SIZE, defaultValue="", tags={ConfigTag.BALANCER}, description="The maximum size that can enter a target datanode in each iteration while balancing. This is the sum of data from multiple sources. The default value is greater than the configured (or default) ozone.scm.container.size by 1GB.")
    private long maxSizeEnteringTarget;
    @Config(key="size.leaving.source.max", type=ConfigType.SIZE, defaultValue="", tags={ConfigTag.BALANCER}, description="The maximum size that can leave a source datanode in each iteration while balancing. This is the sum of data moving to multiple targets. The default value is greater than the configured (or default) ozone.scm.container.size by 1GB.")
    private long maxSizeLeavingSource;
    @Config(key="idle.iterations", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.BALANCER}, description="The idle iteration count of Container Balancer.")
    private int idleIterations = 10;
    @Config(key="exclude.containers", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.BALANCER}, description="List of container IDs to exclude from balancing. For example \"1, 4, 5\" or \"1,4,5\".")
    private String excludeContainers = "";
    @Config(key="move.timeout", type=ConfigType.TIME, defaultValue="30m", timeUnit=TimeUnit.MINUTES, tags={ConfigTag.BALANCER}, description="The amount of time in minutes to allow a single container to move from source to target.")
    private long moveTimeout = Duration.ofMinutes(30L).toMillis();
    @Config(key="balancing.iteration.interval", type=ConfigType.TIME, defaultValue="1h", timeUnit=TimeUnit.MINUTES, tags={ConfigTag.BALANCER}, description="The interval period between each iteration of Container Balancer.")
    private long balancingInterval;
    private DUFactory.Conf duConf;

    public ContainerBalancerConfiguration(OzoneConfiguration config) {
        long size;
        Preconditions.checkNotNull((Object)config, (Object)"OzoneConfiguration should not be null.");
        this.ozoneConfiguration = config;
        this.maxSizeEnteringTarget = size = (long)this.ozoneConfiguration.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.GB) + 0x40000000L;
        this.maxSizeLeavingSource = size;
        this.duConf = (DUFactory.Conf)this.ozoneConfiguration.getObject(DUFactory.Conf.class);
        this.balancingInterval = this.duConf.getRefreshPeriod().toMillis() + Duration.ofMinutes(10L).toMillis();
    }

    public double getThreshold() {
        return Double.parseDouble(this.threshold);
    }

    public void setThreshold(double threshold) {
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException("Threshold must be a fraction in the range 0 to 1.");
        }
        this.threshold = String.valueOf(threshold);
    }

    public int getIdleIteration() {
        return this.idleIterations;
    }

    public void setIdleIteration(int count) {
        if (count < -1 || 0 == count) {
            throw new IllegalArgumentException("Idle iteration count must be larger than 0 or -1(for infinitely running).");
        }
        this.idleIterations = count;
    }

    public double getMaxDatanodesRatioToInvolvePerIteration() {
        return Double.parseDouble(this.maxDatanodesRatioToInvolvePerIteration);
    }

    public void setMaxDatanodesRatioToInvolvePerIteration(double maxDatanodesRatioToInvolvePerIteration) {
        if (maxDatanodesRatioToInvolvePerIteration < 0.0 || maxDatanodesRatioToInvolvePerIteration > 1.0) {
            throw new IllegalArgumentException("Max datanodes to involve ratio must be a double greater than equal to zero and lesser than equal to one.");
        }
        this.maxDatanodesRatioToInvolvePerIteration = String.valueOf(maxDatanodesRatioToInvolvePerIteration);
    }

    public long getMaxSizeToMovePerIteration() {
        return this.maxSizeToMovePerIteration;
    }

    public void setMaxSizeToMovePerIteration(long maxSizeToMovePerIteration) {
        this.maxSizeToMovePerIteration = maxSizeToMovePerIteration;
    }

    public long getMaxSizeEnteringTarget() {
        return this.maxSizeEnteringTarget;
    }

    public void setMaxSizeEnteringTarget(long maxSizeEnteringTarget) {
        this.maxSizeEnteringTarget = maxSizeEnteringTarget;
    }

    public long getMaxSizeLeavingSource() {
        return this.maxSizeLeavingSource;
    }

    public void setMaxSizeLeavingSource(long maxSizeLeavingSource) {
        this.maxSizeLeavingSource = maxSizeLeavingSource;
    }

    public Set<ContainerID> getExcludeContainers() {
        if (this.excludeContainers.isEmpty()) {
            return new HashSet<ContainerID>();
        }
        return Arrays.stream(this.excludeContainers.split(",")).map(s -> {
            s = s.trim();
            return ContainerID.valueOf((long)Long.parseLong(s));
        }).collect(Collectors.toSet());
    }

    public void setExcludeContainers(String excludeContainers) {
        this.excludeContainers = excludeContainers;
    }

    public Duration getMoveTimeout() {
        return Duration.ofMillis(this.moveTimeout);
    }

    public void setMoveTimeout(Duration duration) {
        this.moveTimeout = duration.toMillis();
    }

    public Duration getBalancingInterval() {
        return Duration.ofMillis(this.balancingInterval);
    }

    public void setBalancingInterval(Duration balancingInterval) {
        if (balancingInterval.toMillis() > this.duConf.getRefreshPeriod().toMillis()) {
            this.balancingInterval = balancingInterval.toMillis();
        } else {
            LOG.warn("Balancing interval duration must be greater than du refresh period, {} milliseconds", (Object)this.duConf.getRefreshPeriod().toMillis());
        }
    }

    public OzoneConfiguration getOzoneConfiguration() {
        return this.ozoneConfiguration;
    }

    public String toString() {
        return String.format("Container Balancer Configuration values:%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %dB%n", "Key", "Value", "Threshold", this.threshold, "Max Datanodes to Involve per Iteration(ratio)", this.maxDatanodesRatioToInvolvePerIteration, "Max Size to Move per Iteration", this.maxSizeToMovePerIteration);
    }
}

