/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalContainerReportHandler.class);
    private final NodeManager nodeManager;

    public IncrementalContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext) {
        super(containerManager, scmContext, LOG);
        this.nodeManager = nodeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher) {
        DatanodeDetails dd;
        DatanodeDetails dnFromReport = report.getDatanodeDetails();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing incremental container report from data node {}", (Object)dnFromReport.getUuid());
        }
        if ((dd = this.nodeManager.getNodeByUuid(dnFromReport.getUuidString())) == null) {
            LOG.warn("Received container report from unknown datanode {}", (Object)dnFromReport);
            return;
        }
        boolean success = true;
        DatanodeDetails datanodeDetails = dd;
        synchronized (datanodeDetails) {
            for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList()) {
                try {
                    ContainerID id = ContainerID.valueOf((long)replicaProto.getContainerID());
                    if (!replicaProto.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED)) {
                        this.nodeManager.addContainer(dd, id);
                    }
                    this.processContainerReplica(dd, replicaProto, publisher);
                }
                catch (ContainerNotFoundException e) {
                    success = false;
                    LOG.warn("Container {} not found!", (Object)replicaProto.getContainerID());
                }
                catch (NodeNotFoundException ex) {
                    success = false;
                    LOG.error("Received ICR from unknown datanode {}", (Object)report.getDatanodeDetails(), (Object)ex);
                }
                catch (ContainerReplicaNotFoundException e) {
                    success = false;
                    LOG.warn("Container {} replica not found!", (Object)replicaProto.getContainerID());
                }
                catch (IOException | InvalidStateTransitionException e) {
                    success = false;
                    LOG.error("Exception while processing ICR for container {}", (Object)replicaProto.getContainerID(), (Object)e);
                }
            }
        }
        this.getContainerManager().notifyContainerReportProcessing(false, success);
    }

    protected NodeManager getNodeManager() {
        return this.nodeManager;
    }
}

