/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReportHandler.class);
    private final NodeManager nodeManager;
    private final ContainerManager containerManager;
    private final String unknownContainerHandleAction;
    static final String UNKNOWN_CONTAINER_ACTION_WARN = "WARN";
    static final String UNKNOWN_CONTAINER_ACTION_DELETE = "DELETE";

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext, OzoneConfiguration conf) {
        super(containerManager, scmContext, LOG);
        this.nodeManager = nodeManager;
        this.containerManager = containerManager;
        if (conf != null) {
            ScmConfig scmConfig = (ScmConfig)conf.getObject(ScmConfig.class);
            this.unknownContainerHandleAction = scmConfig.getUnknownContainerAction();
        } else {
            this.unknownContainerHandleAction = UNKNOWN_CONTAINER_ACTION_WARN;
        }
    }

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager) {
        this(nodeManager, containerManager, SCMContext.emptyContext(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        DatanodeDetails dnFromReport = reportFromDatanode.getDatanodeDetails();
        DatanodeDetails datanodeDetails = this.nodeManager.getNodeByUuid(dnFromReport.getUuidString());
        if (datanodeDetails == null) {
            LOG.warn("Received container report from unknown datanode {}", (Object)dnFromReport);
            return;
        }
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport();
        try {
            DatanodeDetails datanodeDetails2 = datanodeDetails;
            synchronized (datanodeDetails2) {
                List replicas = containerReport.getReportsList();
                Set<ContainerID> containersInSCM = this.nodeManager.getContainers(datanodeDetails);
                Set<ContainerID> containersInDn = replicas.parallelStream().map(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto::getContainerID).map(ContainerID::valueOf).collect(Collectors.toSet());
                HashSet<ContainerID> missingReplicas = new HashSet<ContainerID>(containersInSCM);
                missingReplicas.removeAll(containersInDn);
                this.processContainerReplicas(datanodeDetails, replicas, publisher);
                this.processMissingReplicas(datanodeDetails, missingReplicas);
                this.nodeManager.setContainers(datanodeDetails, containersInDn);
                this.containerManager.notifyContainerReportProcessing(true, true);
            }
        }
        catch (NodeNotFoundException ex) {
            this.containerManager.notifyContainerReportProcessing(true, false);
            LOG.error("Received container report from unknown datanode {}.", (Object)datanodeDetails, (Object)ex);
        }
    }

    private void processContainerReplicas(DatanodeDetails datanodeDetails, List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> replicas, EventPublisher publisher) {
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : replicas) {
            try {
                this.processContainerReplica(datanodeDetails, replicaProto, publisher);
            }
            catch (ContainerNotFoundException e) {
                if (this.unknownContainerHandleAction.equals(UNKNOWN_CONTAINER_ACTION_WARN)) {
                    LOG.error("Received container report for an unknown container {} from datanode {}.", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
                    continue;
                }
                if (!this.unknownContainerHandleAction.equals(UNKNOWN_CONTAINER_ACTION_DELETE)) continue;
                ContainerID containerId = ContainerID.valueOf((long)replicaProto.getContainerID());
                this.deleteReplica(containerId, datanodeDetails, publisher, "unknown");
            }
            catch (IOException | InvalidStateTransitionException e) {
                LOG.error("Exception while processing container report for container {} from datanode {}.", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
            }
        }
    }

    private void processMissingReplicas(DatanodeDetails datanodeDetails, Set<ContainerID> missingReplicas) {
        for (ContainerID id : missingReplicas) {
            try {
                this.containerManager.getContainerReplicas(id).stream().filter(replica -> replica.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                    try {
                        this.containerManager.removeContainerReplica(id, (ContainerReplica)replica);
                    }
                    catch (ContainerNotFoundException | ContainerReplicaNotFoundException throwable) {
                        // empty catch block
                    }
                });
            }
            catch (ContainerNotFoundException e) {
                LOG.warn("Cannot remove container replica, container {} not found.", (Object)id, (Object)e);
            }
        }
    }
}

