/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerEventHandler
implements EventHandler<ContainerID> {
    public static final Logger LOG = LoggerFactory.getLogger(CloseContainerEventHandler.class);
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final SCMContext scmContext;

    public CloseContainerEventHandler(PipelineManager pipelineManager, ContainerManager containerManager, SCMContext scmContext) {
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.scmContext = scmContext;
    }

    public void onMessage(ContainerID containerID, EventPublisher publisher) {
        LOG.info("Close container Event triggered for container : {}", (Object)containerID);
        try {
            ContainerInfo container;
            if (this.containerManager.getContainer(containerID).getState() == HddsProtos.LifeCycleState.OPEN) {
                this.containerManager.updateContainerState(containerID, HddsProtos.LifeCycleEvent.FINALIZE);
            }
            if ((container = this.containerManager.getContainer(containerID)).getState() == HddsProtos.LifeCycleState.CLOSING) {
                CloseContainerCommand command = new CloseContainerCommand(containerID.getId(), container.getPipelineID());
                command.setTerm(this.scmContext.getTermOfLeader());
                command.setEncodedToken(this.getContainerToken(containerID));
                this.getNodes(container).forEach(arg_0 -> CloseContainerEventHandler.lambda$onMessage$0(publisher, (SCMCommand)command, arg_0));
            } else {
                LOG.warn("Cannot close container {}, which is in {} state.", (Object)containerID, (Object)container.getState());
            }
        }
        catch (NotLeaderException nle) {
            LOG.warn("Skip sending close container command, since current SCM is not leader.", (Throwable)nle);
        }
        catch (IOException | InvalidStateTransitionException ex) {
            LOG.error("Failed to close the container {}.", (Object)containerID, (Object)ex);
        }
    }

    private String getContainerToken(ContainerID containerID) {
        StorageContainerManager scm = this.scmContext.getScm();
        return scm != null ? scm.getContainerTokenGenerator().generateEncodedToken(containerID) : "";
    }

    private List<DatanodeDetails> getNodes(ContainerInfo container) throws ContainerNotFoundException, NotLeaderException {
        try {
            return this.pipelineManager.getPipeline(container.getPipelineID()).getNodes();
        }
        catch (PipelineNotFoundException ex) {
            return this.containerManager.getContainerReplicas(container.containerID()).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        }
    }

    private static /* synthetic */ void lambda$onMessage$0(EventPublisher publisher, SCMCommand command, DatanodeDetails node) {
        publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(node.getUuid(), command));
    }
}

