/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.ScmBlockDeletingServiceMetrics;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockDeletingService
extends BackgroundService
implements SCMService {
    public static final Logger LOG = LoggerFactory.getLogger(SCMBlockDeletingService.class);
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 1;
    private final DeletedBlockLog deletedBlockLog;
    private final NodeManager nodeManager;
    private final EventPublisher eventPublisher;
    private final SCMContext scmContext;
    private int blockDeleteLimitSize;
    private ScmBlockDeletingServiceMetrics metrics;
    private final Lock serviceLock = new ReentrantLock();
    private SCMService.ServiceStatus serviceStatus = SCMService.ServiceStatus.PAUSING;

    public SCMBlockDeletingService(DeletedBlockLog deletedBlockLog, NodeManager nodeManager, EventPublisher eventPublisher, SCMContext scmContext, SCMServiceManager serviceManager, Duration interval, long serviceTimeout, ConfigurationSource conf, ScmBlockDeletingServiceMetrics metrics) {
        super("SCMBlockDeletingService", interval.toMillis(), TimeUnit.MILLISECONDS, 1, serviceTimeout);
        this.deletedBlockLog = deletedBlockLog;
        this.nodeManager = nodeManager;
        this.eventPublisher = eventPublisher;
        this.scmContext = scmContext;
        this.metrics = metrics;
        this.blockDeleteLimitSize = ((ScmConfig)conf.getObject(ScmConfig.class)).getBlockDeletionLimit();
        Preconditions.checkArgument((this.blockDeleteLimitSize > 0 ? 1 : 0) != 0, (Object)"Block deletion limit should be positive.");
        serviceManager.register(this);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new DeletedBlockTransactionScanner());
        return queue;
    }

    @VisibleForTesting
    public void setBlockDeleteTXNum(int numTXs) {
        this.blockDeleteLimitSize = numTXs;
    }

    @Override
    public void notifyStatusChanged() {
        this.serviceLock.lock();
        try {
            this.serviceStatus = this.scmContext.isLeaderReady() ? SCMService.ServiceStatus.RUNNING : SCMService.ServiceStatus.PAUSING;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public boolean shouldRun() {
        this.serviceLock.lock();
        try {
            boolean bl = this.serviceStatus == SCMService.ServiceStatus.RUNNING;
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public String getServiceName() {
        return SCMBlockDeletingService.class.getSimpleName();
    }

    @Override
    public void stop() {
        throw new RuntimeException("Not supported operation.");
    }

    @VisibleForTesting
    public ScmBlockDeletingServiceMetrics getMetrics() {
        return this.metrics;
    }

    private class DeletedBlockTransactionScanner
    implements BackgroundTask {
        private DeletedBlockTransactionScanner() {
        }

        public int getPriority() {
            return 1;
        }

        public BackgroundTaskResult.EmptyTaskResult call() throws Exception {
            List<DatanodeDetails> datanodes;
            if (!SCMBlockDeletingService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            long startTime = Time.monotonicNow();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running DeletedBlockTransactionScanner");
            }
            if ((datanodes = SCMBlockDeletingService.this.nodeManager.getNodes(NodeStatus.inServiceHealthy())) != null) {
                try {
                    DatanodeDeletedBlockTransactions transactions = SCMBlockDeletingService.this.deletedBlockLog.getTransactions(SCMBlockDeletingService.this.blockDeleteLimitSize);
                    if (transactions.isEmpty()) {
                        return BackgroundTaskResult.EmptyTaskResult.newResult();
                    }
                    for (Map.Entry<UUID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> entry : transactions.getDatanodeTransactionMap().entrySet()) {
                        UUID dnId = entry.getKey();
                        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> dnTXs = entry.getValue();
                        if (dnTXs.isEmpty()) continue;
                        DeleteBlocksCommand command = new DeleteBlocksCommand(dnTXs);
                        command.setTerm(SCMBlockDeletingService.this.scmContext.getTermOfLeader());
                        SCMBlockDeletingService.this.eventPublisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(dnId, (SCMCommand)command));
                        SCMBlockDeletingService.this.metrics.incrBlockDeletionCommandSent();
                        SCMBlockDeletingService.this.metrics.incrBlockDeletionTransactionSent(dnTXs.size());
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Added delete block command for datanode {} in the queue, number of delete block transactions: {}{}", new Object[]{dnId, dnTXs.size(), LOG.isTraceEnabled() ? ", TxID list: " + String.join((CharSequence)",", transactions.getTransactionIDList(dnId)) : ""});
                    }
                    LOG.info("Totally added {} blocks to be deleted for {} datanodes, task elapsed time: {}ms", new Object[]{transactions.getBlocksDeleted(), transactions.getDatanodeTransactionMap().size(), Time.monotonicNow() - startTime});
                }
                catch (NotLeaderException nle) {
                    LOG.warn("Skip current run, since not leader any more.", (Throwable)nle);
                    return BackgroundTaskResult.EmptyTaskResult.newResult();
                }
                catch (IOException e) {
                    LOG.error("Failed to get block deletion transactions from delTX log", (Throwable)e);
                    return BackgroundTaskResult.EmptyTaskResult.newResult();
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

