/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogStateManager;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogStateManagerImpl;
import org.apache.hadoop.hdds.scm.block.ScmBlockDeletingServiceMetrics;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SequenceIdGenerator;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedBlockLogImpl
implements DeletedBlockLog,
EventHandler<CommandStatusReportHandler.DeleteBlockStatus> {
    public static final Logger LOG = LoggerFactory.getLogger(DeletedBlockLogImpl.class);
    private final int maxRetry;
    private final ContainerManager containerManager;
    private final Lock lock;
    private Map<Long, Set<UUID>> transactionToDNsCommitMap;
    private Map<Long, Integer> transactionToRetryCountMap;
    private final DeletedBlockLogStateManager deletedBlockLogStateManager;
    private final SCMContext scmContext;
    private final SequenceIdGenerator sequenceIdGen;
    private final ScmBlockDeletingServiceMetrics metrics;

    public DeletedBlockLogImpl(ConfigurationSource conf, ContainerManager containerManager, SCMRatisServer ratisServer, Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTXTable, DBTransactionBuffer dbTxBuffer, SCMContext scmContext, SequenceIdGenerator sequenceIdGen, ScmBlockDeletingServiceMetrics metrics) {
        this.maxRetry = conf.getInt("ozone.scm.block.deletion.max.retry", 4096);
        this.containerManager = containerManager;
        this.lock = new ReentrantLock();
        this.transactionToDNsCommitMap = new ConcurrentHashMap<Long, Set<UUID>>();
        this.transactionToRetryCountMap = new ConcurrentHashMap<Long, Integer>();
        this.deletedBlockLogStateManager = DeletedBlockLogStateManagerImpl.newBuilder().setConfiguration(conf).setDeletedBlocksTable(deletedBlocksTXTable).setContainerManager(containerManager).setRatisServer(ratisServer).setSCMDBTransactionBuffer(dbTxBuffer).build();
        this.scmContext = scmContext;
        this.sequenceIdGen = sequenceIdGen;
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getFailedTransactions() throws IOException {
        this.lock.lock();
        try {
            ArrayList failedTXs = Lists.newArrayList();
            try (TableIterator<Long, Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> iter = this.deletedBlockLogStateManager.getReadOnlyIterator();){
                while (iter.hasNext()) {
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)((Table.KeyValue)iter.next()).getValue();
                    if (delTX.getCount() != -1) continue;
                    failedTXs.add(delTX);
                }
            }
            ArrayList arrayList = failedTXs;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCount(List<Long> txIDs) throws IOException {
        this.lock.lock();
        try {
            ArrayList<Long> txIDsToUpdate = new ArrayList<Long>();
            for (Long txID : txIDs) {
                int currentCount = this.transactionToRetryCountMap.getOrDefault(txID, 0);
                if (currentCount > this.maxRetry) continue;
                if (++currentCount > this.maxRetry) {
                    txIDsToUpdate.add(txID);
                }
                this.transactionToRetryCountMap.put(txID, currentCount);
            }
            if (!txIDsToUpdate.isEmpty()) {
                this.deletedBlockLogStateManager.increaseRetryCountOfTransactionInDB(txIDsToUpdate);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction constructNewTransaction(long txID, long containerID, List<Long> blocks) {
        return StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder().setTxID(txID).setContainerID(containerID).addAllLocalID(blocks).setCount(0).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransactions(List<StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult> transactionResults, UUID dnID) {
        this.lock.lock();
        try {
            ArrayList<Long> txIDsToBeDeleted = new ArrayList<Long>();
            for (StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult transactionResult : transactionResults) {
                if (this.isTransactionFailed(transactionResult)) {
                    this.metrics.incrBlockDeletionTransactionFailure();
                    continue;
                }
                try {
                    List containerDns;
                    this.metrics.incrBlockDeletionTransactionSuccess();
                    long txID = transactionResult.getTxID();
                    Set<UUID> dnsWithCommittedTxn = this.transactionToDNsCommitMap.get(txID);
                    ContainerID containerId = ContainerID.valueOf((long)transactionResult.getContainerID());
                    if (dnsWithCommittedTxn == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Transaction txId={} commit by dnId={} for containerID={} failed. Corresponding entry not found.", new Object[]{txID, dnID, containerId});
                        continue;
                    }
                    dnsWithCommittedTxn.add(dnID);
                    ContainerInfo container = this.containerManager.getContainer(containerId);
                    Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(containerId);
                    if (Math.min(replicas.size(), dnsWithCommittedTxn.size()) >= container.getReplicationConfig().getRequiredNodes() && dnsWithCommittedTxn.containsAll(containerDns = replicas.stream().map(ContainerReplica::getDatanodeDetails).map(DatanodeDetails::getUuid).collect(Collectors.toList()))) {
                        this.transactionToDNsCommitMap.remove(txID);
                        this.transactionToRetryCountMap.remove(txID);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Purging txId={} from block deletion log", (Object)txID);
                        }
                        txIDsToBeDeleted.add(txID);
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Datanode txId={} containerId={} committed by dnId={}", new Object[]{txID, containerId, dnID});
                }
                catch (IOException e) {
                    LOG.warn("Could not commit delete block transaction: " + transactionResult.getTxID(), (Throwable)e);
                }
            }
            try {
                this.deletedBlockLogStateManager.removeTransactionsFromDB(txIDsToBeDeleted);
                this.metrics.incrBlockDeletionTransactionCompleted(txIDsToBeDeleted.size());
            }
            catch (IOException e) {
                LOG.warn("Could not commit delete block transactions: " + txIDsToBeDeleted, (Throwable)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isTransactionFailed(StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got block deletion ACK from datanode, TXIDs={}, success={}", (Object)result.getTxID(), (Object)result.getSuccess());
        }
        if (!result.getSuccess()) {
            LOG.warn("Got failed ACK for TXID={}, prepare to resend the TX in next interval", (Object)result.getTxID());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumOfValidTransactions() throws IOException {
        this.lock.lock();
        try {
            AtomicInteger num = new AtomicInteger(0);
            try (TableIterator<Long, Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> iter = this.deletedBlockLogStateManager.getReadOnlyIterator();){
                while (iter.hasNext()) {
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)((Table.KeyValue)iter.next()).getValue();
                    if (delTX.getCount() <= -1) continue;
                    num.incrementAndGet();
                }
            }
            int n = num.get();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reinitialize(Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedTable) {
        this.deletedBlockLogStateManager.reinitialize(deletedTable);
    }

    public void onBecomeLeader() {
        this.transactionToDNsCommitMap.clear();
        this.transactionToRetryCountMap.clear();
    }

    public void onFlush() {
        this.deletedBlockLogStateManager.onFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactions(Map<Long, List<Long>> containerBlocksMap) throws IOException {
        this.lock.lock();
        try {
            ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> txsToBeAdded = new ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>();
            for (Map.Entry<Long, List<Long>> entry : containerBlocksMap.entrySet()) {
                long nextTXID = this.sequenceIdGen.getNextId("delTxnId");
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx = this.constructNewTransaction(nextTXID, entry.getKey(), entry.getValue());
                txsToBeAdded.add(tx);
            }
            this.deletedBlockLogStateManager.addTransactionsToDB(txsToBeAdded);
            this.metrics.incrBlockDeletionTransactionCreated(txsToBeAdded.size());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
    }

    private void getTransaction(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx, DatanodeDeletedBlockTransactions transactions) {
        try {
            Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(ContainerID.valueOf((long)tx.getContainerID()));
            for (ContainerReplica replica : replicas) {
                UUID dnID = replica.getDatanodeDetails().getUuid();
                Set<UUID> dnsWithTransactionCommitted = this.transactionToDNsCommitMap.get(tx.getTxID());
                if (dnsWithTransactionCommitted != null && dnsWithTransactionCommitted.contains(dnID)) continue;
                transactions.addTransactionToDN(dnID, tx);
            }
        }
        catch (IOException e) {
            LOG.warn("Got container info error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatanodeDeletedBlockTransactions getTransactions(int blockDeletionLimit) throws IOException {
        this.lock.lock();
        try {
            DatanodeDeletedBlockTransactions transactions = new DatanodeDeletedBlockTransactions();
            try (TableIterator<Long, Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> iter = this.deletedBlockLogStateManager.getReadOnlyIterator();){
                int numBlocksAdded = 0;
                ArrayList<Long> txIDs = new ArrayList<Long>();
                while (iter.hasNext() && numBlocksAdded < blockDeletionLimit) {
                    Table.KeyValue keyValue = (Table.KeyValue)iter.next();
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction txn = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)keyValue.getValue();
                    ContainerID id = ContainerID.valueOf((long)txn.getContainerID());
                    try {
                        if (txn.getCount() <= -1 || txn.getCount() > this.maxRetry || this.containerManager.getContainer(id).isOpen()) continue;
                        numBlocksAdded += txn.getLocalIDCount();
                        this.getTransaction(txn, transactions);
                        this.transactionToDNsCommitMap.putIfAbsent(txn.getTxID(), new LinkedHashSet());
                    }
                    catch (ContainerNotFoundException ex) {
                        LOG.warn("Container: " + id + " was not found for the transaction: " + txn);
                        txIDs.add(txn.getTxID());
                    }
                }
                if (!txIDs.isEmpty()) {
                    this.deletedBlockLogStateManager.removeTransactionsFromDB(txIDs);
                    this.metrics.incrBlockDeletionTransactionCompleted(txIDs.size());
                }
            }
            DatanodeDeletedBlockTransactions datanodeDeletedBlockTransactions = transactions;
            return datanodeDeletedBlockTransactions;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onMessage(CommandStatusReportHandler.DeleteBlockStatus deleteBlockStatus, EventPublisher publisher) {
        if (!this.scmContext.isLeader()) {
            LOG.warn("Skip commit transactions since current SCM is not leader.");
            return;
        }
        StorageContainerDatanodeProtocolProtos.CommandStatus.Status status = deleteBlockStatus.getCmdStatus().getStatus();
        if (status == StorageContainerDatanodeProtocolProtos.CommandStatus.Status.EXECUTED) {
            StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto ackProto = deleteBlockStatus.getCmdStatus().getBlockDeletionAck();
            this.commitTransactions(ackProto.getResultsList(), UUID.fromString(ackProto.getDnId()));
            this.metrics.incrBlockDeletionCommandSuccess();
        } else if (status == StorageContainerDatanodeProtocolProtos.CommandStatus.Status.FAILED) {
            this.metrics.incrBlockDeletionCommandFailure();
        } else {
            LOG.error("Delete Block Command is not executed yet.");
            return;
        }
    }
}

