/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.safemode.Precheck;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ScmUtils.class);

    private ScmUtils() {
    }

    public static void preCheck(HddsProtos.ScmOps operation, Precheck ... preChecks) throws SCMException {
        for (Precheck preCheck : preChecks) {
            preCheck.check(operation);
        }
    }

    public static File createSCMDir(String dirPath) {
        File dirFile = new File(dirPath);
        if (!dirFile.mkdirs() && !dirFile.exists()) {
            throw new IllegalArgumentException("Unable to create path: " + dirFile);
        }
        return dirFile;
    }

    public static InetSocketAddress getScmBlockProtocolServerAddress(OzoneConfiguration conf, String localScmServiceId, String nodeId) {
        String bindHostKey = ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.bind.host", (String[])new String[]{localScmServiceId, nodeId});
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{bindHostKey});
        String addressKey = ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.address", (String[])new String[]{localScmServiceId, nodeId});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{addressKey});
        if (port.isPresent()) {
            ScmUtils.logWarn("ozone.scm.block.client.address", "ozone.scm.block.client.port");
        }
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(conf.getInt(ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.port", (String[])new String[]{localScmServiceId, nodeId}), conf.getInt("ozone.scm.block.client.port", 9863)))));
    }

    public static String getScmBlockProtocolServerAddressKey(String serviceId, String nodeId) {
        return ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.address", (String[])new String[]{serviceId, nodeId});
    }

    public static InetSocketAddress getClientProtocolServerAddress(OzoneConfiguration conf, String localScmServiceId, String nodeId) {
        String bindHostKey = ConfUtils.addKeySuffixes((String)"ozone.scm.client.bind.host", (String[])new String[]{localScmServiceId, nodeId});
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{bindHostKey}).orElse("0.0.0.0");
        String addressKey = ConfUtils.addKeySuffixes((String)"ozone.scm.client.address", (String[])new String[]{localScmServiceId, nodeId});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{addressKey});
        if (port.isPresent()) {
            ScmUtils.logWarn("ozone.scm.client.address", "ozone.scm.client.port");
        }
        return NetUtils.createSocketAddr((String)(host + ":" + port.orElse(conf.getInt(ConfUtils.addKeySuffixes((String)"ozone.scm.client.port", (String[])new String[]{localScmServiceId, nodeId}), conf.getInt("ozone.scm.client.port", 9860)))));
    }

    public static String getClientProtocolServerAddressKey(String serviceId, String nodeId) {
        return ConfUtils.addKeySuffixes((String)"ozone.scm.client.address", (String[])new String[]{serviceId, nodeId});
    }

    public static InetSocketAddress getScmDataNodeBindAddress(ConfigurationSource conf, String localScmServiceId, String nodeId) {
        String bindHostKey = ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.bind.host", (String[])new String[]{localScmServiceId, nodeId});
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{bindHostKey});
        String addressKey = ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.address", (String[])new String[]{localScmServiceId, nodeId});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{addressKey});
        if (port.isPresent()) {
            ScmUtils.logWarn("ozone.scm.datanode.address", "ozone.scm.datanode.port");
        }
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(conf.getInt(ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{localScmServiceId, nodeId}), conf.getInt("ozone.scm.datanode.port", 9861)))));
    }

    public static String getScmDataNodeBindAddressKey(String serviceId, String nodeId) {
        return ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.address", (String[])new String[]{serviceId, nodeId});
    }

    private static void logWarn(String confKey, String portKey) {
        LOG.warn("ConfigKey {} is deprecated, For configuring different ports for each SCM use PortConfigKey {} appended with serviceId and nodeId. If want to configure same port configure {}", new Object[]{confKey, portKey, portKey});
    }

    public static boolean shouldRemovePeers(ConfigurationSource conf) {
        int pipelineLimitPerDn = conf.getInt("ozone.scm.datanode.pipeline.limit", 2);
        return 1 != pipelineLimitPerDn && conf.getBoolean("ozone.scm.datanode.disallow.same.peers", false);
    }
}

