/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementStatusDefault;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCMCommonPlacementPolicy
implements PlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMCommonPlacementPolicy.class);
    private final NodeManager nodeManager;
    private final Random rand;
    private final ConfigurationSource conf;
    private final boolean shouldRemovePeers;
    private ContainerPlacementStatus validPlacement = new ContainerPlacementStatusDefault(1, 1, 1);
    private ContainerPlacementStatus invalidPlacement = new ContainerPlacementStatusDefault(0, 1, 1);

    public SCMCommonPlacementPolicy(NodeManager nodeManager, ConfigurationSource conf) {
        this.nodeManager = nodeManager;
        this.rand = new Random();
        this.conf = conf;
        this.shouldRemovePeers = ScmUtils.shouldRemovePeers(conf);
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Random getRand() {
        return this.rand;
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }

    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        List<DatanodeDetails> healthyNodes = this.nodeManager.getNodes(NodeStatus.inServiceHealthy());
        if (excludedNodes != null) {
            healthyNodes.removeAll(excludedNodes);
        }
        if (healthyNodes.size() == 0) {
            String msg = "No healthy node found to allocate container.";
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
        if (healthyNodes.size() < nodesRequired) {
            String msg = String.format("Not enough healthy nodes to allocate container. %d  datanodes required. Found %d", nodesRequired, healthyNodes.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return this.filterNodesWithSpace(healthyNodes, nodesRequired, metadataSizeRequired, dataSizeRequired);
    }

    public List<DatanodeDetails> filterNodesWithSpace(List<DatanodeDetails> nodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        List<DatanodeDetails> nodesWithSpace = nodes.stream().filter(d -> SCMCommonPlacementPolicy.hasEnoughSpace(d, metadataSizeRequired, dataSizeRequired)).collect(Collectors.toList());
        if (nodesWithSpace.size() < nodesRequired) {
            String msg = String.format("Unable to find enough nodes that meet the space requirement of %d bytes for metadata and %d bytes for data in healthy node set. Required %d. Found %d.", metadataSizeRequired, dataSizeRequired, nodesRequired, nodesWithSpace.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_NODES_WITH_SPACE);
        }
        return nodesWithSpace;
    }

    public static boolean hasEnoughSpace(DatanodeDetails datanodeDetails, long metadataSizeRequired, long dataSizeRequired) {
        Preconditions.checkArgument((boolean)(datanodeDetails instanceof DatanodeInfo));
        boolean enoughForData = false;
        boolean enoughForMeta = false;
        DatanodeInfo datanodeInfo = (DatanodeInfo)datanodeDetails;
        if (dataSizeRequired > 0L) {
            for (StorageContainerDatanodeProtocolProtos.StorageReportProto storageReportProto : datanodeInfo.getStorageReports()) {
                if (storageReportProto.getRemaining() <= dataSizeRequired) continue;
                enoughForData = true;
                break;
            }
        } else {
            enoughForData = true;
        }
        if (!enoughForData) {
            return false;
        }
        if (metadataSizeRequired > 0L) {
            for (StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto metadataStorageReportProto : datanodeInfo.getMetadataStorageReports()) {
                if (metadataStorageReportProto.getRemaining() <= metadataSizeRequired) continue;
                enoughForMeta = true;
                break;
            }
        } else {
            enoughForMeta = true;
        }
        return enoughForData && enoughForMeta;
    }

    public List<DatanodeDetails> getResultSet(int nodesRequired, List<DatanodeDetails> healthyNodes) throws SCMException {
        ArrayList<DatanodeDetails> results = new ArrayList<DatanodeDetails>();
        for (int x = 0; x < nodesRequired; ++x) {
            DatanodeDetails nodeId = this.chooseNode(healthyNodes);
            if (nodeId == null) continue;
            this.removePeers(nodeId, healthyNodes);
            results.add(nodeId);
        }
        if (results.size() < nodesRequired) {
            LOG.error("Unable to find the required number of healthy nodes that meet the criteria. Required nodes: {}, Found nodes: {}", (Object)nodesRequired, (Object)results.size());
            throw new SCMException("Unable to find required number of nodes.", SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return results;
    }

    public abstract DatanodeDetails chooseNode(List<DatanodeDetails> var1);

    protected int getRequiredRackCount(int numReplicas) {
        return 1;
    }

    public ContainerPlacementStatus validateContainerPlacement(List<DatanodeDetails> dns, int replicas) {
        NetworkTopology topology = this.nodeManager.getClusterNetworkTopologyMap();
        int requiredRacks = this.getRequiredRackCount(replicas);
        if (topology == null || replicas == 1 || requiredRacks == 1) {
            if (dns.size() > 0) {
                return this.validPlacement;
            }
            return this.invalidPlacement;
        }
        int numRacks = 1;
        int maxLevel = topology.getMaxLevel();
        numRacks = topology.getNumOfNodes(maxLevel - 1);
        long currentRackCount = dns.stream().map(d -> topology.getAncestor((Node)d, 1)).distinct().count();
        if (replicas < requiredRacks) {
            requiredRacks = replicas;
        }
        return new ContainerPlacementStatusDefault((int)currentRackCount, requiredRacks, numRacks);
    }

    public void removePeers(DatanodeDetails dn, List<DatanodeDetails> healthyList) {
        if (this.shouldRemovePeers) {
            healthyList.removeAll(this.nodeManager.getPeerList(dn));
        }
    }

    public boolean isValidNode(DatanodeDetails datanodeDetails, long metadataSizeRequired, long dataSizeRequired) {
        DatanodeInfo datanodeInfo = (DatanodeInfo)this.getNodeManager().getNodeByUuid(datanodeDetails.getUuidString());
        if (datanodeInfo == null) {
            LOG.error("Failed to find the DatanodeInfo for datanode {}", (Object)datanodeDetails);
        } else if (datanodeInfo.getNodeStatus().isNodeWritable() && SCMCommonPlacementPolicy.hasEnoughSpace(datanodeInfo, metadataSizeRequired, dataSizeRequired)) {
            LOG.debug("Datanode {} is chosen. Required metadata size is {} and required data size is {}", new Object[]{datanodeDetails.toString(), metadataSizeRequired, dataSizeRequired});
            return true;
        }
        return false;
    }
}

