/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.protocol.StorageContainerDatanodeProtocol;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolPB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerDatanodeProtocolServerSideTranslatorPB
implements StorageContainerDatanodeProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerDatanodeProtocolServerSideTranslatorPB.class);
    private final StorageContainerDatanodeProtocol impl;
    private final OzoneProtocolMessageDispatcher<StorageContainerDatanodeProtocolProtos.SCMDatanodeRequest, StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse, ProtocolMessageEnum> dispatcher;

    public StorageContainerDatanodeProtocolServerSideTranslatorPB(StorageContainerDatanodeProtocol impl, ProtocolMessageMetrics<ProtocolMessageEnum> protocolMessageMetrics) {
        this.impl = impl;
        this.dispatcher = new OzoneProtocolMessageDispatcher("SCMDatanodeProtocol", protocolMessageMetrics, LOG);
    }

    public StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto register(StorageContainerDatanodeProtocolProtos.SCMRegisterRequestProto request) throws IOException {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerRequestProto = request.getContainerReport();
        StorageContainerDatanodeProtocolProtos.NodeReportProto dnNodeReport = request.getNodeReport();
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = request.getPipelineReports();
        StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo = null;
        layoutInfo = request.hasDataNodeLayoutVersion() ? request.getDataNodeLayoutVersion() : UpgradeUtils.toLayoutVersionProto(HDDSLayoutFeature.INITIAL_VERSION.layoutVersion(), HDDSLayoutFeature.INITIAL_VERSION.layoutVersion());
        return this.impl.register(request.getExtendedDatanodeDetails(), dnNodeReport, containerRequestProto, pipelineReport, layoutInfo);
    }

    public StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse submitRequest(RpcController controller, StorageContainerDatanodeProtocolProtos.SCMDatanodeRequest request) throws ServiceException {
        return (StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse)this.dispatcher.processRequest((Object)request, this::processMessage, (Object)request.getCmdType(), request.getTraceID());
    }

    public StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse processMessage(StorageContainerDatanodeProtocolProtos.SCMDatanodeRequest request) throws ServiceException {
        try {
            StorageContainerDatanodeProtocolProtos.Type cmdType = request.getCmdType();
            switch (cmdType) {
                case GetVersion: {
                    return StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse.newBuilder().setCmdType(cmdType).setStatus(StorageContainerDatanodeProtocolProtos.Status.OK).setGetVersionResponse(this.impl.getVersion(request.getGetVersionRequest())).build();
                }
                case SendHeartbeat: {
                    return StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse.newBuilder().setCmdType(cmdType).setStatus(StorageContainerDatanodeProtocolProtos.Status.OK).setSendHeartbeatResponse(this.impl.sendHeartbeat(request.getSendHeartbeatRequest())).build();
                }
                case Register: {
                    return StorageContainerDatanodeProtocolProtos.SCMDatanodeResponse.newBuilder().setCmdType(cmdType).setStatus(StorageContainerDatanodeProtocolProtos.Status.OK).setRegisterResponse(this.register(request.getRegisterRequest())).build();
                }
            }
            throw new ServiceException("Unknown command type: " + cmdType);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

