/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;

public class VersionResponse {
    private final int version;
    private final Map<String, String> values;

    public VersionResponse(int version, Map<String, String> values) {
        this.version = version;
        this.values = values;
    }

    public VersionResponse(int version) {
        this.version = version;
        this.values = new HashMap<String, String>();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VersionResponse getFromProtobuf(StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto response) {
        return new VersionResponse(response.getSoftwareVersion(), response.getKeysList().stream().collect(Collectors.toMap(HddsProtos.KeyValue::getKey, HddsProtos.KeyValue::getValue)));
    }

    public void put(String key, String value) {
        if (this.values.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate key in version response");
        }
        this.values.put(key, value);
    }

    public StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto getProtobufMessage() {
        LinkedList<HddsProtos.KeyValue> list = new LinkedList<HddsProtos.KeyValue>();
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            list.add(HddsProtos.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto.newBuilder().setSoftwareVersion(this.version).addAllKeys(list).build();
    }

    public String getValue(String key) {
        return this.values.get(key);
    }

    public static class Builder {
        private int version;
        private Map<String, String> values = new HashMap<String, String>();

        Builder() {
        }

        public Builder setVersion(int ver) {
            this.version = ver;
            return this;
        }

        public Builder addValue(String key, String value) {
            if (this.values.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate key in version response");
            }
            this.values.put(key, value);
            return this;
        }

        public VersionResponse build() {
            return new VersionResponse(this.version, this.values);
        }
    }
}

