/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.upgrade;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;

public class DataNodeUpgradeFinalizer
extends BasicUpgradeFinalizer<DatanodeStateMachine, HDDSLayoutVersionManager> {
    public DataNodeUpgradeFinalizer(HDDSLayoutVersionManager versionManager) {
        super((AbstractLayoutVersionManager)versionManager);
    }

    public void preFinalizeUpgrade(DatanodeStateMachine dsm) throws IOException {
        if (!this.canFinalizeDataNode(dsm)) {
            ((HDDSLayoutVersionManager)this.getVersionManager()).setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_REQUIRED);
            String msg = "Pre Finalization checks failed on the DataNode.";
            this.logAndEmit(msg);
            throw new UpgradeException(msg, UpgradeException.ResultCodes.PREFINALIZE_VALIDATION_FAILED);
        }
    }

    private boolean canFinalizeDataNode(DatanodeStateMachine dsm) {
        Iterator<Container<?>> containerIt = dsm.getContainer().getController().getContainers();
        while (containerIt.hasNext()) {
            Container<?> ctr = containerIt.next();
            ContainerProtos.ContainerDataProto.State state = ctr.getContainerState();
            long id = ((ContainerData)ctr.getContainerData()).getContainerID();
            switch (state) {
                case OPEN: 
                case CLOSING: {
                    LOG.warn("FinalizeUpgrade : Waiting for container {} to close, current state is: {}", (Object)id, (Object)state);
                    return false;
                }
            }
        }
        return true;
    }

    public void finalizeUpgrade(DatanodeStateMachine dsm) throws UpgradeException {
        super.finalizeUpgrade(lf -> arg_0 -> ((HDDSLayoutFeature)((HDDSLayoutFeature)lf)).datanodeAction(arg_0), (Storage)dsm.getLayoutStorage());
    }

    public void runPrefinalizeStateActions(Storage storage, DatanodeStateMachine dsm) throws IOException {
        super.runPrefinalizeStateActions(lf -> arg_0 -> ((HDDSLayoutFeature)((HDDSLayoutFeature)lf)).datanodeAction(arg_0), storage, (Object)dsm);
    }
}

