/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;

@Metrics(about="Closed container replication metrics", context="dfs")
public class MeasuredReplicator
implements ContainerReplicator,
AutoCloseable {
    private static final String NAME = ContainerReplicator.class.toString();
    private final ContainerReplicator delegate;
    @Metric
    private MutableCounterLong success;
    @Metric
    private MutableGaugeLong successTime;
    @Metric
    private MutableCounterLong failure;
    @Metric
    private MutableGaugeLong queueTime;
    @Metric
    private MutableGaugeLong transferredBytes;

    public MeasuredReplicator(ContainerReplicator delegate) {
        this.delegate = delegate;
        DefaultMetricsSystem.instance().register(NAME, "Closed container replication", (Object)this);
    }

    @Override
    public void replicate(ReplicationTask task) {
        long start = System.currentTimeMillis();
        long msInQueue = (Instant.now().getNano() - task.getQueued().getNano()) / 1000000;
        this.queueTime.incr(msInQueue);
        this.delegate.replicate(task);
        if (task.getStatus() == ReplicationTask.Status.FAILED) {
            this.failure.incr();
        } else if (task.getStatus() == ReplicationTask.Status.DONE) {
            this.transferredBytes.incr(task.getTransferredBytes());
            this.success.incr();
            this.successTime.incr(System.currentTimeMillis() - start);
        }
    }

    @Override
    public void close() throws Exception {
        DefaultMetricsSystem.instance().unregisterSource(NAME);
    }

    @VisibleForTesting
    public MutableCounterLong getSuccess() {
        return this.success;
    }

    @VisibleForTesting
    public MutableGaugeLong getSuccessTime() {
        return this.successTime;
    }

    @VisibleForTesting
    public MutableCounterLong getFailure() {
        return this.failure;
    }

    @VisibleForTesting
    public MutableGaugeLong getQueueTime() {
        return this.queueTime;
    }

    @VisibleForTesting
    public MutableGaugeLong getTransferredBytes() {
        return this.transferredBytes;
    }
}

