/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerGrpc;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.StorageVolumeChecker;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.BlockDeletingService;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerDataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerMetadataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScrubberConfiguration;
import org.apache.hadoop.ozone.container.replication.ReplicationServer;
import org.apache.hadoop.util.Timer;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneContainer.class);
    private final HddsDispatcher hddsDispatcher;
    private final Map<ContainerProtos.ContainerType, Handler> handlers;
    private final ConfigurationSource config;
    private final MutableVolumeSet volumeSet;
    private final MutableVolumeSet metaVolumeSet;
    private final StorageVolumeChecker volumeChecker;
    private final ContainerSet containerSet;
    private final XceiverServerSpi writeChannel;
    private final XceiverServerSpi readChannel;
    private final ContainerController controller;
    private ContainerMetadataScanner metadataScanner;
    private List<ContainerDataScanner> dataScanners;
    private final BlockDeletingService blockDeletingService;
    private final GrpcTlsConfig tlsClientConfig;
    private final AtomicReference<InitializingStatus> initializingStatus;
    private final ReplicationServer replicationServer;
    private DatanodeDetails datanodeDetails;
    private StateContext context;

    public OzoneContainer(DatanodeDetails datanodeDetails, ConfigurationSource conf, StateContext context, CertificateClient certClient) throws IOException {
        this.config = conf;
        this.datanodeDetails = datanodeDetails;
        this.context = context;
        this.volumeChecker = this.getVolumeChecker(conf);
        this.volumeSet = new MutableVolumeSet(datanodeDetails.getUuidString(), conf, context, StorageVolume.VolumeType.DATA_VOLUME, this.volumeChecker);
        this.volumeSet.setFailedVolumeListener(this::handleVolumeFailures);
        this.metaVolumeSet = new MutableVolumeSet(datanodeDetails.getUuidString(), conf, context, StorageVolume.VolumeType.META_VOLUME, this.volumeChecker);
        this.containerSet = new ContainerSet();
        this.metadataScanner = null;
        this.buildContainerSet();
        ContainerMetrics metrics = ContainerMetrics.create(conf);
        this.handlers = Maps.newHashMap();
        Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender = containerReplicaProto -> {
            StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto icr = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.newBuilder().addReport(containerReplicaProto).build();
            context.addIncrementalReport((GeneratedMessage)icr);
            context.getParent().triggerHeartbeat();
        };
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            this.handlers.put(containerType, Handler.getHandlerForContainerType(containerType, conf, context.getParent().getDatanodeDetails().getUuidString(), this.containerSet, this.volumeSet, metrics, icrSender));
        }
        SecurityConfig secConf = new SecurityConfig(conf);
        this.hddsDispatcher = new HddsDispatcher(this.config, this.containerSet, this.volumeSet, this.handlers, context, metrics, TokenVerifier.create((SecurityConfig)secConf, (CertificateClient)certClient));
        this.controller = new ContainerController(this.containerSet, this.handlers);
        this.writeChannel = XceiverServerRatis.newXceiverServerRatis(datanodeDetails, this.config, this.hddsDispatcher, this.controller, certClient, context);
        this.replicationServer = new ReplicationServer(this.controller, (ReplicationServer.ReplicationConfig)conf.getObject(ReplicationServer.ReplicationConfig.class), secConf, certClient);
        this.readChannel = new XceiverServerGrpc(datanodeDetails, this.config, this.hddsDispatcher, certClient);
        Duration svcInterval = ((DatanodeConfiguration)conf.getObject(DatanodeConfiguration.class)).getBlockDeletionInterval();
        long serviceTimeout = this.config.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new BlockDeletingService(this, svcInterval.toMillis(), serviceTimeout, TimeUnit.MILLISECONDS, this.config);
        if (certClient != null && secConf.isGrpcTlsEnabled()) {
            List x509Certificates = HAUtils.buildCAX509List((CertificateClient)certClient, (ConfigurationSource)conf);
            this.tlsClientConfig = new GrpcTlsConfig(certClient.getPrivateKey(), certClient.getCertificate(), x509Certificates, true);
        } else {
            this.tlsClientConfig = null;
        }
        this.initializingStatus = new AtomicReference<InitializingStatus>(InitializingStatus.UNINITIALIZED);
    }

    public GrpcTlsConfig getTlsClientConfig() {
        return this.tlsClientConfig;
    }

    private void buildContainerSet() {
        Iterator<StorageVolume> volumeSetIterator = this.volumeSet.getVolumesList().iterator();
        ArrayList<Thread> volumeThreads = new ArrayList<Thread>();
        long startTime = System.currentTimeMillis();
        while (volumeSetIterator.hasNext()) {
            StorageVolume volume = volumeSetIterator.next();
            Thread thread = new Thread(new ContainerReader(this.volumeSet, (HddsVolume)volume, this.containerSet, this.config));
            thread.start();
            volumeThreads.add(thread);
        }
        try {
            for (int i = 0; i < volumeThreads.size(); ++i) {
                ((Thread)volumeThreads.get(i)).join();
            }
        }
        catch (InterruptedException ex) {
            LOG.error("Volume Threads Interrupted exception", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        LOG.info("Build ContainerSet costs {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
    }

    private void startContainerScrub() {
        ContainerScrubberConfiguration c = (ContainerScrubberConfiguration)this.config.getObject(ContainerScrubberConfiguration.class);
        boolean enabled = c.isEnabled();
        if (!enabled) {
            LOG.info("Background container scanner has been disabled.");
        } else {
            if (this.metadataScanner == null) {
                this.metadataScanner = new ContainerMetadataScanner(c, this.controller);
            }
            this.metadataScanner.start();
            this.dataScanners = new ArrayList<ContainerDataScanner>();
            for (StorageVolume v : this.volumeSet.getVolumesList()) {
                ContainerDataScanner s = new ContainerDataScanner(c, this.controller, (HddsVolume)v);
                s.start();
                this.dataScanners.add(s);
            }
        }
    }

    private void stopContainerScrub() {
        if (this.metadataScanner == null) {
            return;
        }
        this.metadataScanner.shutdown();
        this.metadataScanner = null;
        for (ContainerDataScanner s : this.dataScanners) {
            s.shutdown();
        }
    }

    public void start(String clusterId) throws IOException {
        if (!this.initializingStatus.compareAndSet(InitializingStatus.UNINITIALIZED, InitializingStatus.INITIALIZING)) {
            while (this.initializingStatus.get() != InitializingStatus.INITIALIZED) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info("Ignore. OzoneContainer already started.");
            return;
        }
        LOG.info("Attempting to start container services.");
        this.startContainerScrub();
        this.replicationServer.start();
        this.datanodeDetails.setPort(DatanodeDetails.Port.Name.REPLICATION, this.replicationServer.getPort());
        this.writeChannel.start();
        this.readChannel.start();
        this.hddsDispatcher.init();
        this.hddsDispatcher.setClusterId(clusterId);
        this.blockDeletingService.start();
        this.initializingStatus.set(InitializingStatus.INITIALIZED);
    }

    public void stop() {
        LOG.info("Attempting to stop container services.");
        this.stopContainerScrub();
        this.replicationServer.stop();
        this.writeChannel.stop();
        this.readChannel.stop();
        this.handlers.values().forEach(Handler::stop);
        this.hddsDispatcher.shutdown();
        this.volumeChecker.shutdownAndWait(0, TimeUnit.SECONDS);
        this.volumeSet.shutdown();
        this.metaVolumeSet.shutdown();
        this.blockDeletingService.shutdown();
        ContainerMetrics.remove();
    }

    public void handleVolumeFailures() {
        if (this.containerSet != null) {
            this.containerSet.handleVolumeFailures();
        }
    }

    @VisibleForTesting
    public ContainerSet getContainerSet() {
        return this.containerSet;
    }

    public StorageContainerDatanodeProtocolProtos.PipelineReportsProto getPipelineReport() {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder pipelineReportsProto = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        pipelineReportsProto.addAllPipelineReport(this.writeChannel.getPipelineReport());
        return pipelineReportsProto.build();
    }

    public XceiverServerSpi getWriteChannel() {
        return this.writeChannel;
    }

    public XceiverServerSpi getReadChannel() {
        return this.readChannel;
    }

    public ContainerController getController() {
        return this.controller;
    }

    public StorageContainerDatanodeProtocolProtos.NodeReportProto getNodeReport() throws IOException {
        StorageLocationReport[] reports = this.volumeSet.getStorageReport();
        StorageContainerDatanodeProtocolProtos.NodeReportProto.Builder nrb = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder();
        for (int i = 0; i < reports.length; ++i) {
            nrb.addStorageReport(reports[i].getProtoBufMessage());
        }
        StorageLocationReport[] metaReports = this.metaVolumeSet.getStorageReport();
        for (int i = 0; i < metaReports.length; ++i) {
            nrb.addMetadataStorageReport(metaReports[i].getMetadataProtoBufMessage());
        }
        return nrb.build();
    }

    @VisibleForTesting
    public ContainerDispatcher getDispatcher() {
        return this.hddsDispatcher;
    }

    public MutableVolumeSet getVolumeSet() {
        return this.volumeSet;
    }

    public MutableVolumeSet getMetaVolumeSet() {
        return this.metaVolumeSet;
    }

    @VisibleForTesting
    StorageVolumeChecker getVolumeChecker(ConfigurationSource conf) {
        return new StorageVolumeChecker(conf, new Timer());
    }

    static enum InitializingStatus {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

