/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.container.scrub")
public class ContainerScrubberConfiguration {
    public static final String HDDS_CONTAINER_SCRUB_ENABLED = "hdds.container.scrub.enabled";
    @Config(key="enabled", type=ConfigType.BOOLEAN, defaultValue="false", tags={ConfigTag.STORAGE}, description="Config parameter to enable container scrubber.")
    private boolean enabled;
    @Config(key="metadata.scan.interval", type=ConfigType.TIME, defaultValue="3h", tags={ConfigTag.STORAGE}, description="Config parameter define time interval in milliseconds between two metadata scans by container scrubber.")
    private long metadataScanInterval;
    @Config(key="data.scan.interval", type=ConfigType.TIME, defaultValue="1m", tags={ConfigTag.STORAGE}, description="Minimum time interval between two iterations of container data scanning.  If an iteration takes less time than this, the scanner will wait before starting the next iteration.")
    private long dataScanInterval;
    @Config(key="volume.bytes.per.second", type=ConfigType.LONG, defaultValue="1048576", tags={ConfigTag.STORAGE}, description="Config parameter to throttle I/O bandwidth used by scrubber per volume.")
    private long bandwidthPerVolume;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMetadataScanInterval(long metadataScanInterval) {
        this.metadataScanInterval = metadataScanInterval;
    }

    public long getMetadataScanInterval() {
        return this.metadataScanInterval;
    }

    public void setDataScanInterval(long dataScanInterval) {
        this.dataScanInterval = dataScanInterval;
    }

    public long getDataScanInterval() {
        return this.dataScanInterval;
    }

    public long getBandwidthPerVolume() {
        return this.bandwidthPerVolume;
    }
}

