/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="DataNode container data scrubber metrics", context="dfs")
public final class ContainerDataScrubberMetrics {
    private final String name;
    private final MetricsSystem ms;
    @Metric(value={"number of containers scanned in the current iteration"})
    private MutableGaugeInt numContainersScanned;
    @Metric(value={"number of unhealthy containers found in the current iteration"})
    private MutableGaugeInt numUnHealthyContainers;
    @Metric(value={"number of iterations of scanner completed since the restart"})
    private MutableCounterInt numScanIterations;
    @Metric(value={"disk bandwidth used by the container data scrubber per volume"})
    private MutableRate numBytesScanned;

    public int getNumContainersScanned() {
        return this.numContainersScanned.value();
    }

    public void incNumContainersScanned() {
        this.numContainersScanned.incr();
    }

    public void resetNumContainersScanned() {
        this.numContainersScanned.decr(this.getNumContainersScanned());
    }

    public int getNumUnHealthyContainers() {
        return this.numUnHealthyContainers.value();
    }

    public void incNumUnHealthyContainers() {
        this.numUnHealthyContainers.incr();
    }

    public void resetNumUnhealthyContainers() {
        this.numUnHealthyContainers.decr(this.getNumUnHealthyContainers());
    }

    public int getNumScanIterations() {
        return this.numScanIterations.value();
    }

    public void incNumScanIterations() {
        this.numScanIterations.incr();
    }

    public double getNumBytesScannedMean() {
        return this.numBytesScanned.lastStat().mean();
    }

    public long getNumBytesScannedSampleCount() {
        return this.numBytesScanned.lastStat().numSamples();
    }

    public double getNumBytesScannedStdDev() {
        return this.numBytesScanned.lastStat().stddev();
    }

    public void incNumBytesScanned(long bytes) {
        this.numBytesScanned.add(bytes);
    }

    public void unregister() {
        this.ms.unregisterSource(this.name);
    }

    public String getName() {
        return this.name;
    }

    private ContainerDataScrubberMetrics(String name, MetricsSystem ms) {
        this.name = name;
        this.ms = ms;
    }

    public static ContainerDataScrubberMetrics create(String volumeName) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        String name = "ContainerDataScrubberMetrics-" + (volumeName.isEmpty() ? "UndefinedDataNodeVolume" + ThreadLocalRandom.current().nextInt() : volumeName.replace(':', '-'));
        return (ContainerDataScrubberMetrics)ms.register(name, null, (Object)new ContainerDataScrubberMetrics(name, ms));
    }
}

