/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.metadata.DatanodeTable;

public class SchemaOneDeletedBlocksTable
extends DatanodeTable<String, ChunkInfoList> {
    public static final String DELETED_KEY_PREFIX = "#deleted#";

    public SchemaOneDeletedBlocksTable(Table<String, ChunkInfoList> table) {
        super(table);
    }

    @Override
    public void put(String key, ChunkInfoList value) throws IOException {
        super.put(SchemaOneDeletedBlocksTable.prefix(key), value);
    }

    @Override
    public void putWithBatch(BatchOperation batch, String key, ChunkInfoList value) throws IOException {
        super.putWithBatch(batch, SchemaOneDeletedBlocksTable.prefix(key), value);
    }

    @Override
    public void delete(String key) throws IOException {
        super.delete(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, String key) throws IOException {
        super.deleteWithBatch(batch, SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public boolean isExist(String key) throws IOException {
        return super.isExist(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public ChunkInfoList get(String key) throws IOException {
        return (ChunkInfoList)super.get(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public ChunkInfoList getIfExist(String key) throws IOException {
        return (ChunkInfoList)super.getIfExist(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public ChunkInfoList getReadCopy(String key) throws IOException {
        return (ChunkInfoList)super.getReadCopy(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public List<? extends Table.KeyValue<String, ChunkInfoList>> getRangeKVs(String startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return SchemaOneDeletedBlocksTable.unprefix(super.getRangeKVs(SchemaOneDeletedBlocksTable.prefix(startKey), count, new MetadataKeyFilters.MetadataKeyFilter[]{SchemaOneDeletedBlocksTable.getDeletedFilter()}));
    }

    @Override
    public List<? extends Table.KeyValue<String, ChunkInfoList>> getSequentialRangeKVs(String startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return SchemaOneDeletedBlocksTable.unprefix(super.getSequentialRangeKVs(SchemaOneDeletedBlocksTable.prefix(startKey), count, new MetadataKeyFilters.MetadataKeyFilter[]{SchemaOneDeletedBlocksTable.getDeletedFilter()}));
    }

    private static String prefix(String key) {
        String result = null;
        if (key != null) {
            result = DELETED_KEY_PREFIX + key;
        }
        return result;
    }

    private static String unprefix(String key) {
        String result = null;
        if (key != null && key.startsWith(DELETED_KEY_PREFIX)) {
            result = key.replaceFirst(DELETED_KEY_PREFIX, "");
        }
        return result;
    }

    private static List<Table.KeyValue<String, ChunkInfoList>> unprefix(List<? extends Table.KeyValue<String, ChunkInfoList>> kvs) {
        ArrayList<Table.KeyValue<String, ChunkInfoList>> processedKVs = new ArrayList<Table.KeyValue<String, ChunkInfoList>>();
        kvs.forEach(kv -> processedKVs.add(new UnprefixedKeyValue((Table.KeyValue<String, ChunkInfoList>)kv)));
        return processedKVs;
    }

    private static MetadataKeyFilters.KeyPrefixFilter getDeletedFilter() {
        return new MetadataKeyFilters.KeyPrefixFilter().addFilter(DELETED_KEY_PREFIX);
    }

    private static class UnprefixedKeyValue
    implements Table.KeyValue<String, ChunkInfoList> {
        private final Table.KeyValue<String, ChunkInfoList> prefixedKeyValue;

        UnprefixedKeyValue(Table.KeyValue<String, ChunkInfoList> prefixedKeyValue) {
            this.prefixedKeyValue = prefixedKeyValue;
        }

        public String getKey() throws IOException {
            return SchemaOneDeletedBlocksTable.unprefix((String)this.prefixedKeyValue.getKey());
        }

        public ChunkInfoList getValue() throws IOException {
            return (ChunkInfoList)this.prefixedKeyValue.getValue();
        }
    }
}

